/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.mysql;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.JDBCUrl;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.mysql.FailoverProxy;
import org.mariadb.jdbc.internal.mysql.MySQLProtocol;
import org.mariadb.jdbc.internal.mysql.listener.impl.MastersSlavesListener;
import org.mariadb.jdbc.internal.mysql.listener.tools.SearchFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MastersSlavesProtocol
extends MySQLProtocol {
    private static final Logger log = LoggerFactory.getLogger(MastersSlavesProtocol.class);
    boolean masterConnection = false;
    boolean mustBeMasterConnection = false;

    public MastersSlavesProtocol(JDBCUrl url, ReentrantReadWriteLock lock) {
        super(url, lock);
    }

    public static void loop(MastersSlavesListener listener, List<HostAddress> addresses, Map<HostAddress, Long> blacklist, SearchFilter searchFilter) throws QueryException {
        if (log.isDebugEnabled()) {
            log.debug("searching for master:" + searchFilter.isSearchForMaster() + " replica:" + searchFilter.isSearchForSlave() + " addresses:" + addresses);
        }
        LinkedList<HostAddress> loopAddresses = new LinkedList<HostAddress>(addresses);
        int maxConnectionTry = listener.getRetriesAllDown();
        QueryException lastQueryException = null;
        while (!loopAddresses.isEmpty() || !searchFilter.isUniqueLoop() && maxConnectionTry > 0) {
            block17: {
                MastersSlavesProtocol protocol = MastersSlavesProtocol.getNewProtocol(listener.getProxy(), listener.getJdbcUrl());
                if (listener.isExplicitClosed() || !listener.isSecondaryHostFail() && !listener.isMasterHostFail()) {
                    return;
                }
                --maxConnectionTry;
                try {
                    protocol.setHostAddress((HostAddress)loopAddresses.get(0));
                    loopAddresses.remove(0);
                    if (log.isDebugEnabled()) {
                        log.debug("trying to connect to " + protocol.getHostAddress());
                    }
                    protocol.connect();
                    blacklist.remove(protocol.getHostAddress());
                    if (log.isDebugEnabled()) {
                        log.debug("connected to " + (protocol.isMasterConnection() ? "primary " : "replica ") + protocol.getHostAddress());
                    }
                    if (searchFilter.isSearchForMaster() && protocol.isMasterConnection()) {
                        if (MastersSlavesProtocol.foundMaster(listener, protocol, searchFilter)) {
                            return;
                        }
                    } else if (searchFilter.isSearchForSlave() && !protocol.isMasterConnection()) {
                        if (MastersSlavesProtocol.foundSecondary(listener, protocol, searchFilter)) {
                            return;
                        }
                    } else {
                        protocol.close();
                    }
                }
                catch (QueryException e) {
                    lastQueryException = e;
                    blacklist.put(protocol.getHostAddress(), System.currentTimeMillis());
                    if (!log.isDebugEnabled()) break block17;
                    log.debug("Could not connect to " + protocol.getHostAddress() + " searching: " + searchFilter + " error: " + e.getMessage());
                }
            }
            if (!searchFilter.isSearchForMaster() && !searchFilter.isSearchForSlave()) {
                return;
            }
            if (!loopAddresses.isEmpty() || searchFilter.isUniqueLoop() || maxConnectionTry <= 0) continue;
            loopAddresses = new LinkedList<HostAddress>(addresses);
            listener.checkIfTypeHaveChanged(searchFilter);
        }
        if (searchFilter.isSearchForMaster() || searchFilter.isSearchForSlave()) {
            String error = "No active connection found for replica";
            if (searchFilter.isSearchForMaster()) {
                error = "No active connection found for master";
            }
            if (lastQueryException != null) {
                throw new QueryException(error, lastQueryException.getErrorCode(), lastQueryException.getSqlState(), lastQueryException);
            }
            throw new QueryException(error);
        }
    }

    private static boolean foundMaster(MastersSlavesListener listener, MastersSlavesProtocol protocol, SearchFilter searchFilter) {
        protocol.setMustBeMasterConnection(true);
        searchFilter.setSearchForMaster(false);
        listener.foundActiveMaster(protocol);
        if (!searchFilter.isSearchForSlave()) {
            return true;
        }
        return listener.isExplicitClosed() || searchFilter.isFineIfFoundOnlyMaster() || !listener.isSecondaryHostFail();
    }

    private static boolean foundSecondary(MastersSlavesListener listener, MastersSlavesProtocol protocol, SearchFilter searchFilter) {
        searchFilter.setSearchForSlave(false);
        protocol.setMustBeMasterConnection(false);
        listener.foundActiveSecondary(protocol);
        if (!searchFilter.isSearchForMaster()) {
            return true;
        }
        return listener.isExplicitClosed() || searchFilter.isFineIfFoundOnlySlave() || !listener.isMasterHostFail();
    }

    public static MastersSlavesProtocol getNewProtocol(FailoverProxy proxy, JDBCUrl jdbcUrl) {
        MastersSlavesProtocol newProtocol = new MastersSlavesProtocol(jdbcUrl, proxy.lock);
        newProtocol.setProxy(proxy);
        return newProtocol;
    }

    @Override
    public boolean mustBeMasterConnection() {
        return this.mustBeMasterConnection;
    }

    public void setMustBeMasterConnection(boolean mustBeMasterConnection) {
        this.mustBeMasterConnection = mustBeMasterConnection;
    }
}

