/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common.query;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.common.query.Query;
import org.mariadb.jdbc.internal.common.query.QueryType;

public class MySQLQuery
implements Query {
    private final String query;

    public MySQLQuery(String query) {
        this.query = query;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        try {
            byte[] queryToSend = this.query.getBytes("UTF-8");
            os.write(queryToSend, 0, queryToSend.length);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding: " + e.getMessage(), e);
        }
    }

    @Override
    public void writeFirstRewritePart(OutputStream os) throws IOException, QueryException {
        this.writeTo(os);
    }

    @Override
    public void writeLastRewritePart(OutputStream os) throws IOException, QueryException {
    }

    @Override
    public void writeToRewritablePart(OutputStream os, int rewriteOffset) throws IOException, QueryException {
        try {
            byte[] queryToSend = this.query.substring(rewriteOffset).getBytes("UTF-8");
            os.write(44);
            os.write(queryToSend, 0, queryToSend.length);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding: " + e.getMessage(), e);
        }
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.classifyQuery(this.query);
    }

    public boolean equals(Object otherObj) {
        return otherObj instanceof MySQLQuery && ((MySQLQuery)otherObj).query.equals(this.query);
    }

    public void writeTo(OutputStream ostream, int offset, int packLength) throws IOException {
        try {
            byte[] queryToSend = this.query.getBytes("UTF-8");
            ostream.write(queryToSend, offset, packLength);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding: " + e.getMessage(), e);
        }
    }

    @Override
    public void validate() throws QueryException {
    }

    public String toString() {
        return this.query;
    }
}

