/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.internal.common.DefaultOptions;
import org.mariadb.jdbc.internal.common.Options;
import org.mariadb.jdbc.internal.common.UrlHAMode;

public class JDBCUrl {
    private String database;
    private Options options;
    private List<HostAddress> addresses;
    private UrlHAMode haMode;

    private JDBCUrl() {
    }

    protected JDBCUrl(String database, List<HostAddress> addresses, Options options, UrlHAMode haMode) throws SQLException {
        this.options = options;
        this.database = database;
        this.addresses = addresses;
        this.haMode = haMode;
        if (haMode == UrlHAMode.AURORA) {
            for (HostAddress hostAddress : addresses) {
                hostAddress.type = null;
            }
        } else {
            for (HostAddress hostAddress : addresses) {
                if (hostAddress.type != null) continue;
                hostAddress.type = "master";
            }
        }
    }

    static boolean acceptsURL(String url) {
        return url != null && (url.startsWith("jdbc:mariadb:") || url.startsWith("jdbc:mysql:"));
    }

    public static JDBCUrl parse(String url) throws SQLException {
        return JDBCUrl.parse(url, new Properties());
    }

    public static JDBCUrl parse(String url, Properties prop) throws SQLException {
        if (url != null) {
            String[] arr;
            if (prop == null) {
                prop = new Properties();
            }
            if (url.startsWith("jdbc:mysql:")) {
                JDBCUrl jdbcUrl = new JDBCUrl();
                JDBCUrl.parseInternal(jdbcUrl, url, prop);
                return jdbcUrl;
            }
            for (String prefix : arr = new String[]{"jdbc:mysql:thin:", "jdbc:mariadb:"}) {
                if (!url.startsWith(prefix)) continue;
                JDBCUrl jdbcUrl = new JDBCUrl();
                JDBCUrl.parseInternal(jdbcUrl, "jdbc:mysql:" + url.substring(prefix.length()), prop);
                return jdbcUrl;
            }
        }
        return null;
    }

    public void parseUrl(String url) throws SQLException {
        String[] arr;
        if (url.startsWith("jdbc:mysql:")) {
            JDBCUrl.parseInternal(this, url, new Properties());
        }
        for (String prefix : arr = new String[]{"jdbc:mysql:thin:", "jdbc:mariadb:"}) {
            if (!url.startsWith(prefix)) continue;
            JDBCUrl.parseInternal(this, url, new Properties());
        }
    }

    private static void parseInternal(JDBCUrl jdbcUrl, String url, Properties properties) throws SQLException {
        try {
            String[] baseTokens = url.substring(0, url.indexOf("//")).split(":");
            jdbcUrl.haMode = UrlHAMode.NONE;
            if (baseTokens.length > 2) {
                try {
                    jdbcUrl.haMode = UrlHAMode.valueOf(baseTokens[2].toUpperCase());
                }
                catch (IllegalArgumentException i) {
                    throw new IllegalArgumentException("url parameter error '" + baseTokens[2] + "' is a unknown parameter in the url " + url);
                }
            }
            url = url.substring(url.indexOf("//") + 2);
            String[] tokens = url.split("/");
            String hostAddressesString = tokens[0];
            String additionalParameters = tokens.length > 1 ? url.substring(tokens[0].length() + 1) : null;
            jdbcUrl.addresses = HostAddress.parse(hostAddressesString, jdbcUrl.haMode);
            if (additionalParameters == null) {
                jdbcUrl.database = null;
                jdbcUrl.options = DefaultOptions.parse(jdbcUrl.haMode, "", properties);
            } else {
                int ind = additionalParameters.indexOf(63);
                if (ind > -1) {
                    jdbcUrl.database = additionalParameters.substring(0, ind);
                    jdbcUrl.options = DefaultOptions.parse(jdbcUrl.haMode, additionalParameters.substring(ind + 1), properties);
                } else {
                    jdbcUrl.database = additionalParameters;
                    jdbcUrl.options = DefaultOptions.parse(jdbcUrl.haMode, "", properties);
                }
            }
            if (jdbcUrl.haMode == UrlHAMode.AURORA) {
                for (HostAddress hostAddress : jdbcUrl.addresses) {
                    hostAddress.type = null;
                }
            } else {
                for (HostAddress hostAddress : jdbcUrl.addresses) {
                    if (hostAddress.type != null) continue;
                    hostAddress.type = "master";
                }
            }
        }
        catch (IllegalArgumentException i) {
            throw new SQLException(i.getMessage());
        }
    }

    public String getUsername() {
        return this.options.user;
    }

    public String getPassword() {
        return this.options.password;
    }

    public String getDatabase() {
        return this.database;
    }

    public List<HostAddress> getHostAddresses() {
        return this.addresses;
    }

    protected void setUsername(String username) {
        this.options.user = username;
    }

    protected void setPassword(String password) {
        this.options.password = password;
    }

    public Options getOptions() {
        return this.options;
    }

    protected void setDatabase(String database) {
        this.database = database;
    }

    protected void setProperties(String urlParameters) {
        DefaultOptions.parse(this.haMode, urlParameters, this.options);
    }

    public String toString() {
        String s = "jdbc:mysql://";
        if (!this.haMode.equals((Object)UrlHAMode.NONE)) {
            s = "jdbc:mysql:" + this.haMode.toString().toLowerCase() + "://";
        }
        if (this.addresses != null) {
            s = s + HostAddress.toString(this.addresses);
        }
        if (this.database != null) {
            s = s + "/" + this.database;
        }
        return s;
    }

    public UrlHAMode getHaMode() {
        return this.haMode;
    }
}

