/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.mysql.listener.impl;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.JDBCUrl;
import org.mariadb.jdbc.internal.SQLExceptionMapper;
import org.mariadb.jdbc.internal.common.QueryException;
import org.mariadb.jdbc.internal.common.UrlHAMode;
import org.mariadb.jdbc.internal.mysql.HandleErrorResult;
import org.mariadb.jdbc.internal.mysql.MySQLProtocol;
import org.mariadb.jdbc.internal.mysql.Protocol;
import org.mariadb.jdbc.internal.mysql.listener.AbstractMastersListener;
import org.mariadb.jdbc.internal.mysql.listener.tools.SearchFilter;

public class MastersFailoverListener
extends AbstractMastersListener {
    private static final Logger log = Logger.getLogger(MastersFailoverListener.class.getName());
    private final UrlHAMode mode;

    public MastersFailoverListener(JDBCUrl jdbcUrl) {
        super(jdbcUrl);
        this.mode = jdbcUrl.getHaMode();
    }

    @Override
    public void initializeConnection() throws QueryException {
        this.currentProtocol = null;
        log.finest("launching initial loop");
        this.reconnectFailedConnection(new SearchFilter(true, false));
        log.finest("launching initial loop end");
    }

    @Override
    public void preExecute() throws QueryException {
        if (this.currentProtocol != null && this.currentProtocol.isClosed()) {
            if (!this.isExplicitClosed() && this.jdbcUrl.getOptions().autoReconnect) {
                try {
                    this.reconnectFailedConnection(new SearchFilter(this.isMasterHostFail(), false, !this.currentReadOnlyAsked.get(), this.currentReadOnlyAsked.get()));
                }
                catch (QueryException queryException) {}
            } else {
                throw new QueryException("Connection is closed", -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState());
            }
        }
    }

    @Override
    public boolean shouldReconnect() {
        return this.isMasterHostFail();
    }

    @Override
    public void preClose() throws SQLException {
        this.setExplicitClosed(true);
        this.proxy.lock.writeLock().lock();
        try {
            if (this.currentProtocol != null && this.currentProtocol.isConnected()) {
                this.currentProtocol.close();
            }
        }
        finally {
            if (!UrlHAMode.NONE.equals((Object)this.mode)) {
                this.proxy.lock.writeLock().unlock();
                if (this.scheduledFailover != null) {
                    this.scheduledFailover.cancel(true);
                    this.isLooping.set(false);
                }
                this.executorService.shutdownNow();
                try {
                    this.executorService.awaitTermination(15L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    log.finest("executorService interrupted");
                }
            }
        }
        log.finest("preClose connections");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandleErrorResult primaryFail(Method method, Object[] args) throws Throwable {
        boolean alreadyClosed;
        block14: {
            alreadyClosed = !this.currentProtocol.isConnected();
            try {
                if (this.currentProtocol != null && this.currentProtocol.isConnected() && this.currentProtocol.ping()) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Primary node [" + this.currentProtocol.getHostAddress().toString() + "] connection re-established");
                    }
                    if (this.currentProtocol.inTransaction()) {
                        this.currentProtocol.rollback();
                    }
                    return new HandleErrorResult(true);
                }
            }
            catch (QueryException e) {
                this.proxy.lock.writeLock().lock();
                try {
                    this.currentProtocol.close();
                }
                finally {
                    this.proxy.lock.writeLock().unlock();
                }
                if (!this.setMasterHostFail()) break block14;
                this.addToBlacklist(this.currentProtocol.getHostAddress());
            }
        }
        try {
            this.reconnectFailedConnection(new SearchFilter(true, false));
            if (!UrlHAMode.NONE.equals((Object)this.mode)) {
                this.launchFailLoopIfNotlaunched(true);
            }
            if (alreadyClosed) {
                return this.relaunchOperation(method, args);
            }
            return new HandleErrorResult(true);
        }
        catch (Exception e) {
            if (!UrlHAMode.NONE.equals((Object)this.mode)) {
                this.launchFailLoopIfNotlaunched(true);
            }
            return new HandleErrorResult();
        }
    }

    @Override
    public void reconnectFailedConnection(SearchFilter searchFilter) throws QueryException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("search connection searchFilter=" + searchFilter);
        }
        this.currentConnectionAttempts.incrementAndGet();
        this.resetOldsBlackListHosts();
        LinkedList<HostAddress> loopAddress = new LinkedList<HostAddress>(this.jdbcUrl.getHostAddresses());
        if (UrlHAMode.FAILOVER.equals((Object)this.mode)) {
            loopAddress.removeAll(blacklist.keySet());
            Collections.shuffle(loopAddress);
            LinkedList blacklistShuffle = new LinkedList(blacklist.keySet());
            Collections.shuffle(blacklistShuffle);
            loopAddress.addAll(blacklistShuffle);
        } else {
            loopAddress.removeAll(blacklist.keySet());
            loopAddress.addAll(blacklist.keySet());
        }
        if (this.currentProtocol != null && !this.isMasterHostFail()) {
            loopAddress.remove(this.currentProtocol.getHostAddress());
        }
        MySQLProtocol.loop(this, loopAddress, blacklist, searchFilter);
        this.resetMasterFailoverData();
    }

    @Override
    public void switchReadOnlyConnection(Boolean mustBeReadOnly) throws QueryException {
        if (this.currentReadOnlyAsked.compareAndSet(mustBeReadOnly == false, mustBeReadOnly)) {
            this.setSessionReadOnly(mustBeReadOnly);
        }
    }

    @Override
    public void foundActiveMaster(Protocol protocol) throws QueryException {
        if (this.isExplicitClosed()) {
            this.proxy.lock.writeLock().lock();
            try {
                protocol.close();
            }
            finally {
                this.proxy.lock.writeLock().unlock();
            }
            return;
        }
        this.syncConnection(this.currentProtocol, protocol);
        this.proxy.lock.writeLock().lock();
        try {
            if (this.currentProtocol != null && !this.currentProtocol.isClosed()) {
                this.currentProtocol.close();
            }
            this.currentProtocol = protocol;
        }
        finally {
            this.proxy.lock.writeLock().unlock();
        }
        if (this.currentReadOnlyAsked.get()) {
            this.setSessionReadOnly(true);
        }
        if (log.isLoggable(Level.FINE)) {
            if (this.getMasterHostFailTimestamp() > 0L) {
                log.fine("new primary node [" + this.currentProtocol.getHostAddress().toString() + "] connection established after " + (System.currentTimeMillis() - this.getMasterHostFailTimestamp()));
            } else {
                log.fine("new primary node [" + this.currentProtocol.getHostAddress().toString() + "] connection established");
            }
        }
        this.resetMasterFailoverData();
        this.stopFailover();
    }

    @Override
    public void throwFailoverMessage(QueryException queryException, boolean reconnected) throws QueryException {
        HostAddress hostAddress = this.currentProtocol != null ? this.currentProtocol.getHostAddress() : null;
        String firstPart = "Communications link failure with primary" + (hostAddress != null ? " host " + hostAddress.host + ":" + hostAddress.port : "") + ". ";
        String error = "";
        if (this.jdbcUrl.getOptions().autoReconnect) {
            error = this.isMasterHostFail() ? error + " Driver will reconnect automatically in a few millisecond or during next query if append before" : error + " Driver as successfully reconnect connection";
        } else if (reconnected) {
            error = error + " Driver as reconnect connection";
        } else if (this.shouldReconnect()) {
            error = error + " Driver will try to reconnect automatically in a few millisecond or during next query if append before";
        }
        if (queryException == null) {
            throw new QueryException(firstPart + error, -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState());
        }
        error = queryException.getMessage() + ". " + error;
        queryException.setMessage(firstPart + error);
        throw queryException;
    }

    @Override
    public void reconnect() throws QueryException {
        this.reconnectFailedConnection(new SearchFilter(true, false));
    }
}

