/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.mapstruct.ap.internal.model.Field;
import org.mapstruct.ap.internal.model.SupportingMappingMethod;
import org.mapstruct.ap.internal.model.common.ConstructorFragment;
import org.mapstruct.ap.internal.model.common.ModelElement;
import org.mapstruct.ap.internal.model.common.Type;

public class SupportingConstructorFragment
extends ModelElement {
    private final String variableName;
    private final String templateName;
    private final SupportingMappingMethod definingMethod;

    public SupportingConstructorFragment(SupportingMappingMethod definingMethod, ConstructorFragment constructorFragment, String variableName) {
        this.templateName = this.getTemplateNameForClass(constructorFragment.getClass());
        this.definingMethod = definingMethod;
        this.variableName = variableName;
    }

    @Override
    public String getTemplateName() {
        return this.templateName;
    }

    @Override
    public Set<Type> getImportTypes() {
        return Collections.emptySet();
    }

    public SupportingMappingMethod getDefiningMethod() {
        return this.definingMethod;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.variableName == null ? 0 : this.variableName.hashCode());
        result = 31 * result + (this.templateName == null ? 0 : this.templateName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SupportingConstructorFragment other = (SupportingConstructorFragment)obj;
        if (!Objects.equals(this.variableName, other.variableName)) {
            return false;
        }
        return Objects.equals(this.templateName, other.templateName);
    }

    public static void addAllFragmentsIn(Set<SupportingMappingMethod> supportingMappingMethods, Set<SupportingConstructorFragment> targets) {
        for (SupportingMappingMethod supportingMappingMethod : supportingMappingMethods) {
            SupportingConstructorFragment fragment = supportingMappingMethod.getSupportingConstructorFragment();
            if (fragment == null) continue;
            targets.add(supportingMappingMethod.getSupportingConstructorFragment());
        }
    }

    public static SupportingConstructorFragment getSafeConstructorFragment(SupportingMappingMethod method, ConstructorFragment fragment, Field supportingField) {
        if (fragment == null) {
            return null;
        }
        return new SupportingConstructorFragment(method, fragment, supportingField != null ? supportingField.getVariableName() : null);
    }
}

