/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.util;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.mapstruct.ap.internal.util.ElementUtils;
import org.mapstruct.ap.internal.util.IgnoreJRERequirement;
import org.mapstruct.ap.spi.TypeHierarchyErroneousException;

public abstract class AbstractElementUtilsDecorator
implements ElementUtils {
    private final Elements delegate;
    private final Element moduleElement;

    @IgnoreJRERequirement
    AbstractElementUtilsDecorator(ProcessingEnvironment processingEnv, TypeElement mapperElement) {
        this.delegate = processingEnv.getElementUtils();
        this.moduleElement = SourceVersion.RELEASE_8.compareTo(processingEnv.getSourceVersion()) >= 0 ? null : this.delegate.getModuleOf(mapperElement);
    }

    @Override
    @IgnoreJRERequirement
    public PackageElement getPackageElement(CharSequence name) {
        if (this.moduleElement == null) {
            return this.delegate.getPackageElement(name);
        }
        return this.delegate.getPackageElement((ModuleElement)this.moduleElement, name);
    }

    @Override
    @IgnoreJRERequirement
    public TypeElement getTypeElement(CharSequence name) {
        if (this.moduleElement == null) {
            return this.delegate.getTypeElement(name);
        }
        return this.delegate.getTypeElement((ModuleElement)this.moduleElement, name);
    }

    @Override
    public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValuesWithDefaults(AnnotationMirror a) {
        return this.delegate.getElementValuesWithDefaults(a);
    }

    @Override
    public String getDocComment(Element e) {
        return this.delegate.getDocComment(e);
    }

    @Override
    public boolean isDeprecated(Element e) {
        return this.delegate.isDeprecated(e);
    }

    @Override
    public Name getBinaryName(TypeElement type) {
        return this.delegate.getBinaryName(type);
    }

    @Override
    public PackageElement getPackageOf(Element type) {
        return this.delegate.getPackageOf(type);
    }

    @Override
    public List<? extends Element> getAllMembers(TypeElement type) {
        return this.delegate.getAllMembers(type);
    }

    @Override
    public List<? extends AnnotationMirror> getAllAnnotationMirrors(Element e) {
        return this.delegate.getAllAnnotationMirrors(e);
    }

    @Override
    public boolean hides(Element hider, Element hidden) {
        return this.delegate.hides(hider, hidden);
    }

    @Override
    public boolean overrides(ExecutableElement overrider, ExecutableElement overridden, TypeElement type) {
        return this.delegate.overrides(overrider, overridden, type);
    }

    @Override
    public String getConstantExpression(Object value) {
        return this.delegate.getConstantExpression(value);
    }

    @Override
    public void printElements(Writer w, Element ... elements) {
        this.delegate.printElements(w, elements);
    }

    @Override
    public Name getName(CharSequence cs) {
        return this.delegate.getName(cs);
    }

    @Override
    public boolean isFunctionalInterface(TypeElement type) {
        return this.delegate.isFunctionalInterface(type);
    }

    @Override
    public List<ExecutableElement> getAllEnclosedExecutableElements(TypeElement element) {
        ArrayList<ExecutableElement> enclosedElements = new ArrayList<ExecutableElement>();
        element = this.replaceTypeElementIfNecessary(element);
        this.addEnclosedMethodsInHierarchy(enclosedElements, new HashSet<String>(), element, element);
        return enclosedElements;
    }

    @Override
    public List<VariableElement> getAllEnclosedFields(TypeElement element) {
        ArrayList<VariableElement> enclosedElements = new ArrayList<VariableElement>();
        element = this.replaceTypeElementIfNecessary(element);
        this.addEnclosedFieldsInHierarchy(enclosedElements, element, element);
        return enclosedElements;
    }

    private void addEnclosedMethodsInHierarchy(List<ExecutableElement> alreadyAdded, Collection<String> alreadyVisitedElements, TypeElement element, TypeElement parentType) {
        if (element != parentType) {
            element = this.replaceTypeElementIfNecessary(element);
        }
        if (element.asType().getKind() == TypeKind.ERROR) {
            throw new TypeHierarchyErroneousException(element);
        }
        if (!alreadyVisitedElements.add(element.getQualifiedName().toString())) {
            return;
        }
        this.addMethodNotYetOverridden(alreadyAdded, ElementFilter.methodsIn(element.getEnclosedElements()), parentType);
        if (this.hasNonObjectSuperclass(element)) {
            this.addEnclosedMethodsInHierarchy(alreadyAdded, alreadyVisitedElements, this.asTypeElement(element.getSuperclass()), parentType);
        }
        for (TypeMirror typeMirror : element.getInterfaces()) {
            this.addEnclosedMethodsInHierarchy(alreadyAdded, alreadyVisitedElements, this.asTypeElement(typeMirror), parentType);
        }
    }

    private void addMethodNotYetOverridden(List<ExecutableElement> alreadyCollected, List<ExecutableElement> methodsToAdd, TypeElement parentType) {
        ArrayList<ExecutableElement> safeToAdd = new ArrayList<ExecutableElement>(methodsToAdd.size());
        for (ExecutableElement toAdd : methodsToAdd) {
            if (!this.isNotPrivate(toAdd) || !this.isNotObjectEquals(toAdd) || !this.methodWasNotYetOverridden(alreadyCollected, toAdd, parentType)) continue;
            safeToAdd.add(toAdd);
        }
        alreadyCollected.addAll(0, safeToAdd);
    }

    private boolean isNotObjectEquals(ExecutableElement executable) {
        return !executable.getSimpleName().contentEquals("equals") || executable.getParameters().size() != 1 || !this.asTypeElement(executable.getParameters().get(0).asType()).getQualifiedName().contentEquals("java.lang.Object");
    }

    private boolean methodWasNotYetOverridden(List<ExecutableElement> alreadyCollected, ExecutableElement executable, TypeElement parentType) {
        ListIterator<ExecutableElement> it = alreadyCollected.listIterator();
        while (it.hasNext()) {
            ExecutableElement executableInSubtype = it.next();
            if (executableInSubtype == null) continue;
            if (this.delegate.overrides(executableInSubtype, executable, parentType)) {
                return false;
            }
            if (!this.delegate.overrides(executable, executableInSubtype, parentType)) continue;
            it.remove();
            return true;
        }
        return true;
    }

    private void addEnclosedFieldsInHierarchy(List<VariableElement> alreadyAdded, TypeElement element, TypeElement parentType) {
        if (element != parentType) {
            element = this.replaceTypeElementIfNecessary(element);
        }
        if (element.asType().getKind() == TypeKind.ERROR) {
            throw new TypeHierarchyErroneousException(element);
        }
        AbstractElementUtilsDecorator.addFields(alreadyAdded, ElementFilter.fieldsIn(element.getEnclosedElements()));
        if (this.hasNonObjectSuperclass(element)) {
            this.addEnclosedFieldsInHierarchy(alreadyAdded, this.asTypeElement(element.getSuperclass()), parentType);
        }
    }

    private static void addFields(List<VariableElement> alreadyCollected, List<VariableElement> variablesToAdd) {
        ArrayList<VariableElement> safeToAdd = new ArrayList<VariableElement>(variablesToAdd.size());
        safeToAdd.addAll(variablesToAdd);
        alreadyCollected.addAll(0, safeToAdd);
    }

    private boolean hasNonObjectSuperclass(TypeElement element) {
        if (element.getSuperclass().getKind() == TypeKind.ERROR) {
            throw new TypeHierarchyErroneousException(element);
        }
        return element.getSuperclass().getKind() == TypeKind.DECLARED && !this.asTypeElement(element.getSuperclass()).getQualifiedName().toString().equals("java.lang.Object");
    }

    private TypeElement asTypeElement(TypeMirror mirror) {
        return (TypeElement)((DeclaredType)mirror).asElement();
    }

    private boolean isNotPrivate(ExecutableElement executable) {
        return !executable.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    protected abstract TypeElement replaceTypeElementIfNecessary(TypeElement var1);
}

