/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.mapstruct.ap.internal.model.Field;
import org.mapstruct.ap.internal.model.HelperMethod;
import org.mapstruct.ap.internal.model.MappingMethod;
import org.mapstruct.ap.internal.model.SupportingConstructorFragment;
import org.mapstruct.ap.internal.model.SupportingField;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.builtin.BuiltInMethod;

public class SupportingMappingMethod
extends MappingMethod {
    private final String templateName;
    private final Set<Type> importTypes;
    private final Field supportingField;
    private final SupportingConstructorFragment supportingConstructorFragment;
    private final Map<String, Object> templateParameter;

    public SupportingMappingMethod(BuiltInMethod method, Set<Field> existingFields) {
        super(method);
        this.importTypes = method.getImportTypes();
        this.templateName = this.getTemplateNameForClass(method.getClass());
        this.templateParameter = null;
        this.supportingField = SupportingField.getSafeField(this, method.getFieldReference(), existingFields);
        this.supportingConstructorFragment = SupportingConstructorFragment.getSafeConstructorFragment(this, method.getConstructorFragment(), this.supportingField);
    }

    public SupportingMappingMethod(HelperMethod method) {
        super(method);
        this.importTypes = method.getImportTypes();
        this.templateName = this.getTemplateNameForClass(method.getClass());
        this.templateParameter = null;
        this.supportingField = null;
        this.supportingConstructorFragment = null;
    }

    @Override
    public String getTemplateName() {
        return this.templateName;
    }

    @Override
    public Set<Type> getImportTypes() {
        return this.importTypes;
    }

    public Type findType(String name) {
        for (Type type : this.importTypes) {
            if (type.getFullyQualifiedName().contentEquals(name)) {
                return type;
            }
            if (!type.getName().contentEquals(name)) continue;
            return type;
        }
        throw new IllegalArgumentException("No type for given name '" + name + "' found in 'importTypes'.");
    }

    public Field getSupportingField() {
        return this.supportingField;
    }

    public SupportingConstructorFragment getSupportingConstructorFragment() {
        return this.supportingConstructorFragment;
    }

    public Map<String, Object> getTemplateParameter() {
        return this.templateParameter;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SupportingMappingMethod other = (SupportingMappingMethod)obj;
        return Objects.equals(this.getName(), other.getName());
    }
}

