/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.tooling.apt.validator;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Messager;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.linkki.tooling.apt.model.AptAspectSubject;
import org.linkki.tooling.apt.model.AptComponentDeclaration;
import org.linkki.tooling.apt.model.AptModelObject;
import org.linkki.tooling.apt.model.AptPmo;
import org.linkki.tooling.apt.util.ClassNotFoundMessageUtils;
import org.linkki.tooling.apt.util.DynamicAspectMethodName;
import org.linkki.tooling.apt.util.DynamicMethodUtils;
import org.linkki.tooling.apt.util.Either;
import org.linkki.tooling.apt.util.ElementUtils;
import org.linkki.tooling.apt.util.SuppressedWarningsUtils;
import org.linkki.tooling.apt.validator.MessageCodes;
import org.linkki.tooling.apt.validator.Messages;
import org.linkki.tooling.apt.validator.Severity;
import org.linkki.tooling.apt.validator.Validator;
import org.linkki.util.Optionals;

@MessageCodes(value={"NON_PUBLIC_METHOD"})
public class PublicModifierValidator
implements Validator {
    public static final String NON_PUBLIC_METHOD = "NON_PUBLIC_METHOD";
    private final Diagnostic.Kind nonPulbicMethodSeverity;
    private final ElementUtils elementUtils;

    public PublicModifierValidator(Map<String, String> options, ElementUtils elementUtils) {
        this.elementUtils = elementUtils;
        this.nonPulbicMethodSeverity = Severity.of(options, NON_PUBLIC_METHOD, Diagnostic.Kind.ERROR);
    }

    @Override
    public void validate(AptPmo pmo, Messager messager) {
        if (this.nonPulbicMethodSeverity == Diagnostic.Kind.OTHER) {
            return;
        }
        if (SuppressedWarningsUtils.isSuppressed(pmo.getElement(), this.nonPulbicMethodSeverity)) {
            return;
        }
        Stream<ExecutableElement> modelObjectAndComponentMethods = Stream.concat(this.getModelObjectMethods(pmo), this.getComponentMethods(pmo));
        this.printMessages(messager, modelObjectAndComponentMethods);
        Set<ExecutableElement> allMethods = this.elementUtils.getAllMethods(pmo.getElement());
        Stream<ExecutableElement> aspectMethods = pmo.getComponents().stream().flatMap(it -> Stream.concat(it.getAspectBindings().stream(), it.getComponentDeclarations().stream())).flatMap(it -> this.getAspectMethods(messager, allMethods, (AptAspectSubject)it));
        this.printMessages(messager, aspectMethods);
        Stream<ExecutableElement> componentTypeMethods = allMethods.stream().filter(it -> {
            String methodName = it.getSimpleName().toString();
            return methodName.startsWith("get") && methodName.endsWith("ComponentType");
        });
        this.printMessages(messager, componentTypeMethods);
    }

    private Stream<ExecutableElement> getComponentMethods(AptPmo pmo) {
        return pmo.getComponents().stream().flatMap(c -> c.getComponentDeclarations().stream()).map(AptComponentDeclaration::getElement);
    }

    private Stream<ExecutableElement> getModelObjectMethods(AptPmo pmo) {
        return pmo.getModelObjects().stream().map(AptModelObject::getElement).filter(Either::isRight).map(Either::getRight).flatMap(Optionals::stream);
    }

    private Stream<ExecutableElement> getAspectMethods(Messager messager, Set<ExecutableElement> allMethods, AptAspectSubject aspectSubject) {
        TypeElement annotationElement = (TypeElement)aspectSubject.getAnnotationMirror().getAnnotationType().asElement();
        try {
            Class<? extends Annotation> annotationType = this.elementUtils.getAnnotationType(annotationElement);
            Annotation annotation = aspectSubject.getElement().getAnnotation(annotationType);
            Objects.requireNonNull(annotation, "annotation was null");
            Set expectedMethods = DynamicMethodUtils.getExpectedMethods(aspectSubject.getElement(), annotation, messager).stream().map(DynamicAspectMethodName::getExpectedMethodName).collect(Collectors.toSet());
            return allMethods.stream().filter(it -> expectedMethods.contains(it.getSimpleName().toString()));
        }
        catch (ClassNotFoundException e) {
            ClassNotFoundMessageUtils.printAnnotationNotFoundWarning(messager, aspectSubject.getElement(), aspectSubject.getAnnotationMirror());
            return Stream.empty();
        }
    }

    private void printMessages(Messager messager, Stream<ExecutableElement> methods) {
        methods.distinct().filter(it -> !SuppressedWarningsUtils.isSuppressed(it, this.nonPulbicMethodSeverity)).filter(it -> !it.getModifiers().contains((Object)Modifier.PUBLIC)).forEach(method -> this.printMethodNotPulic(messager, (ExecutableElement)method));
    }

    private void printMethodNotPulic(Messager messager, ExecutableElement method) {
        String msg = String.format(Messages.getString(NON_PUBLIC_METHOD), method.getSimpleName(), NON_PUBLIC_METHOD);
        messager.printMessage(this.nonPulbicMethodSeverity, msg, method);
    }
}

