/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.tooling.apt.validator;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationValue;
import javax.tools.Diagnostic;
import org.linkki.tooling.apt.model.AptComponent;
import org.linkki.tooling.apt.model.AptPmo;
import org.linkki.tooling.apt.util.PositionUtil;
import org.linkki.tooling.apt.util.SuppressedWarningsUtils;
import org.linkki.tooling.apt.validator.MessageCodes;
import org.linkki.tooling.apt.validator.Messages;
import org.linkki.tooling.apt.validator.Severity;
import org.linkki.tooling.apt.validator.Validator;

@MessageCodes(value={"POSITION_CLASH"})
public class PositionValidator
implements Validator {
    public static final String POSITION_CLASH = "POSITION_CLASH";
    private final Diagnostic.Kind positionClashSeverity;

    public PositionValidator(Map<String, String> options) {
        this.positionClashSeverity = Severity.of(options, POSITION_CLASH, Diagnostic.Kind.ERROR);
    }

    @Override
    public void validate(AptPmo pmo, Messager messager) {
        if (this.positionClashSeverity == Diagnostic.Kind.OTHER) {
            return;
        }
        if (SuppressedWarningsUtils.isSuppressed(pmo.getElement(), this.positionClashSeverity)) {
            return;
        }
        pmo.getComponents().stream().collect(Collectors.groupingBy(AptComponent::getPosition)).values().stream().filter(it -> it.size() > 1).forEach(samePositionComponents -> this.print(messager, (List<AptComponent>)samePositionComponents));
    }

    private void print(Messager messager, List<AptComponent> collidingComponents) {
        collidingComponents.forEach(component -> {
            String collidingPropertyNames = this.getCollidingPropertyNames(collidingComponents, (AptComponent)component);
            component.getComponentDeclarations().stream().filter(it -> !SuppressedWarningsUtils.isSuppressed(it.getElement(), this.positionClashSeverity)).forEach(componentDeclaration -> {
                String message = Messages.format(POSITION_CLASH, componentDeclaration.getAnnotationMirror(), component.getPosition(), collidingPropertyNames);
                AnnotationValue positionValue = PositionUtil.findPositionAttribute(componentDeclaration.getAttributes()).get().getAnnotationValue();
                messager.printMessage(this.positionClashSeverity, message, componentDeclaration.getElement(), componentDeclaration.getAnnotationMirror(), positionValue);
            });
        });
    }

    private String getCollidingPropertyNames(List<AptComponent> collidingComponents, AptComponent component) {
        int index = collidingComponents.indexOf(component);
        return IntStream.range(0, collidingComponents.size()).filter(it -> it != index).mapToObj(collidingComponents::get).map(AptComponent::getPropertyName).collect(Collectors.joining(", "));
    }
}

