/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.tooling.apt.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Optional<Method> getMethodByName(List<Method> methods, String name) {
        return methods.stream().filter(it -> it.getName().equals(name)).findFirst();
    }

    public static Optional<Object> getAnnotationProperty(Annotation annotation, String propertyName) {
        try {
            return Optional.ofNullable(annotation.annotationType().getMethod(propertyName, new Class[0]).invoke((Object)annotation, new Object[0]));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return Optional.empty();
        }
    }
}

