/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.tooling.apt.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.apache.commons.lang3.tuple.Pair;
import org.linkki.core.binding.descriptor.aspect.annotation.LinkkiAspect;
import org.linkki.core.binding.uicreation.LinkkiComponent;
import org.linkki.core.pmo.ModelObject;
import org.linkki.tooling.apt.model.AptAspectBinding;
import org.linkki.tooling.apt.model.AptAttribute;
import org.linkki.tooling.apt.model.AptComponent;
import org.linkki.tooling.apt.model.AptComponentDeclaration;
import org.linkki.tooling.apt.model.AptModelAttribute;
import org.linkki.tooling.apt.model.AptModelObject;
import org.linkki.tooling.apt.model.AptPmo;
import org.linkki.tooling.apt.util.Either;
import org.linkki.tooling.apt.util.ElementUtils;
import org.linkki.tooling.apt.util.MethodNameUtils;

public class ModelBuilder {
    private final ElementUtils elementUtils;

    public ModelBuilder(ElementUtils elementUtils) {
        this.elementUtils = elementUtils;
    }

    public ElementUtils getElementUtils() {
        return this.elementUtils;
    }

    public AptPmo convertPmo(TypeElement pmoElement) {
        List<ExecutableElement> allMethods = this.getAllMethods(pmoElement);
        List<VariableElement> allFields = this.getAllFields(pmoElement);
        List<AptModelObject> modelObjects = Stream.concat(this.getModelObjectsFromFields(allFields).stream(), this.getModelObjectsFromMethods(allMethods).stream()).collect(Collectors.toList());
        List<AptComponent> components = this.getComponents(modelObjects, allMethods);
        return new AptPmo(modelObjects, components, pmoElement);
    }

    private List<ExecutableElement> getAllMethods(TypeElement pmoElement) {
        return this.elementUtils.getElements().getAllMembers(pmoElement).stream().filter(it -> it.getKind() == ElementKind.METHOD).filter(ExecutableElement.class::isInstance).map(ExecutableElement.class::cast).collect(Collectors.toList());
    }

    private List<VariableElement> getAllFields(TypeElement pmoElement) {
        return this.elementUtils.getElements().getAllMembers(pmoElement).stream().filter(it -> it.getKind() == ElementKind.FIELD).filter(VariableElement.class::isInstance).map(VariableElement.class::cast).collect(Collectors.toList());
    }

    private List<AptModelObject> getModelObjectsFromMethods(List<ExecutableElement> allMethods) {
        return allMethods.stream().filter(it -> it.getAnnotation(ModelObject.class) != null).map(this::convertModelObject).collect(Collectors.toList());
    }

    private List<AptModelObject> getModelObjectsFromFields(List<VariableElement> allFields) {
        return allFields.stream().filter(it -> it.getAnnotation(ModelObject.class) != null).map(this::convertModelObject).collect(Collectors.toList());
    }

    private AptModelObject convertModelObject(ExecutableElement executableElement) {
        ModelObject annotation = executableElement.getAnnotation(ModelObject.class);
        AnnotationMirror annotationMirror = executableElement.getAnnotationMirrors().stream().filter(it -> ((TypeElement)it.getAnnotationType().asElement()).getQualifiedName().contentEquals(ModelObject.class.getName())).findFirst().orElseThrow(() -> new IllegalStateException("expected to find @ModelObject annotation on " + executableElement.getSimpleName()));
        TypeMirror type = executableElement.getReturnType();
        List<AptModelAttribute> modelAttributes = this.convertModelAttributes(type);
        return new AptModelObject(annotation, annotationMirror, Either.right(executableElement), type, modelAttributes);
    }

    private AptModelObject convertModelObject(VariableElement variableElement) {
        ModelObject annotation = variableElement.getAnnotation(ModelObject.class);
        AnnotationMirror annotationMirror = variableElement.getAnnotationMirrors().stream().filter(it -> ((TypeElement)it.getAnnotationType().asElement()).getQualifiedName().contentEquals(ModelObject.class.getName())).findFirst().orElseThrow(() -> new IllegalStateException("expected to find @ModelObject annotation on " + variableElement.getSimpleName()));
        TypeMirror type = variableElement.asType();
        List<AptModelAttribute> modelAttributes = this.convertModelAttributes(type);
        return new AptModelObject(annotation, annotationMirror, Either.left(variableElement), type, modelAttributes);
    }

    private List<AptModelAttribute> convertModelAttributes(TypeMirror type) {
        Set<ExecutableElement> modelObjectAttributes = this.elementUtils.getModelObjectAttributes(type);
        return modelObjectAttributes.stream().map(method -> new AptModelAttribute(MethodNameUtils.getPropertyName(method), (ExecutableElement)method)).collect(Collectors.toList());
    }

    private List<AptComponent> getComponents(List<AptModelObject> modelObjects, List<ExecutableElement> allMethods) {
        Map<String, List<ExecutableElement>> propertiesWithAspects = allMethods.stream().filter(this::hasAspect).collect(Collectors.groupingBy(MethodNameUtils::getPropertyName));
        return propertiesWithAspects.entrySet().stream().filter(it -> this.hasLinkkiComponent((List)it.getValue())).map(it -> {
            String propertyName = (String)it.getKey();
            List methodsWithAspect = (List)it.getValue();
            List<AptComponentDeclaration> componentDeclarations = this.getComponentDeclarations(modelObjects, methodsWithAspect);
            List<AptAspectBinding> aspectBindings = this.getAspectBindings(methodsWithAspect);
            return new AptComponent(propertyName, componentDeclarations, aspectBindings);
        }).collect(Collectors.toList());
    }

    private boolean hasLinkkiComponent(List<ExecutableElement> methods) {
        return methods.stream().anyMatch(method -> method.getAnnotationMirrors().stream().anyMatch(this::hasLinkkiComponent));
    }

    private List<AptComponentDeclaration> getComponentDeclarations(List<AptModelObject> modelObjects, List<ExecutableElement> methodsWithAspect) {
        return methodsWithAspect.stream().flatMap(method -> method.getAnnotationMirrors().stream().filter(this::hasLinkkiComponent).map(annotation -> this.convertComponentDeclaration(modelObjects, (ExecutableElement)method, (AnnotationMirror)annotation))).collect(Collectors.toList());
    }

    private AptComponentDeclaration convertComponentDeclaration(List<AptModelObject> modelObjects, ExecutableElement method, AnnotationMirror annotation) {
        List<AptAttribute> attributes = this.getAttributes(annotation);
        Optional<AptModelObject> modelObject = this.getModelObject(attributes, modelObjects);
        Optional<AptModelAttribute> modelAttribute = this.getModelAttribute(attributes, modelObject, MethodNameUtils.getPropertyName(method));
        return new AptComponentDeclaration(attributes, modelObject, modelAttribute, method, annotation);
    }

    @NonNull
    private List<AptAttribute> getAttributes(AnnotationMirror annotation) {
        List customValueAttributes = annotation.getElementValues().entrySet().stream().map(this::convertAttribute).collect(Collectors.toList());
        Stream<AptAttribute> defaultValueAttributes = annotation.getAnnotationType().asElement().getEnclosedElements().stream().filter(it -> it.getKind() == ElementKind.METHOD).map(ExecutableElement.class::cast).filter(it -> customValueAttributes.stream().map(AptAttribute::getElement).noneMatch(customAttribute -> it.getSimpleName().equals(customAttribute.getSimpleName()))).map(it -> Pair.of((Object)it, (Object)it.getDefaultValue())).filter(it -> it.getRight() != null).map(this::convertAttribute);
        return Stream.concat(customValueAttributes.stream(), defaultValueAttributes).collect(Collectors.toList());
    }

    private AptAttribute convertAttribute(Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> attribute) {
        String name = attribute.getKey().getSimpleName().toString();
        ExecutableElement element = attribute.getKey();
        AnnotationValue annotationValue = attribute.getValue();
        return new AptAttribute(name, element, annotationValue);
    }

    @NonNull
    private Optional<AptModelObject> getModelObject(@NonNull List<AptAttribute> attributes, List<AptModelObject> modelObjects) {
        return AptAttribute.findByName(attributes, "modelObject").flatMap(modelObjectAttribute -> {
            String modelObjectName = (String)modelObjectAttribute.getValue();
            return modelObjects.stream().filter(modelObject -> modelObject.getAnnotation().name().equals(modelObjectName)).findFirst();
        });
    }

    @NonNull
    private Optional<AptModelAttribute> getModelAttribute(@NonNull List<AptAttribute> attributes, @NonNull Optional<AptModelObject> modelObject, String fallback) {
        return AptAttribute.findByName(attributes, "modelAttribute").flatMap(modelAttributeAttribute -> modelObject.flatMap(mo -> {
            String modelAttributeName = modelAttributeAttribute.getValue().toString();
            String attributeName = modelAttributeName.isEmpty() ? fallback : modelAttributeName;
            return mo.getModelAttributes().stream().filter(it -> it.getName().equals(attributeName)).findFirst();
        }));
    }

    private List<AptAspectBinding> getAspectBindings(List<ExecutableElement> methodsWithAspect) {
        return methodsWithAspect.stream().flatMap(method -> method.getAnnotationMirrors().stream().filter(annotation -> !this.hasLinkkiComponent((AnnotationMirror)annotation)).filter(this::hasAspect).map(annotation -> this.convertAspectBinding((ExecutableElement)method, (AnnotationMirror)annotation))).collect(Collectors.toList());
    }

    private AptAspectBinding convertAspectBinding(ExecutableElement method, AnnotationMirror annotation) {
        List<AptAttribute> attributes = this.getAttributes(annotation);
        return new AptAspectBinding(attributes, method, annotation);
    }

    private boolean hasAspect(ExecutableElement method) {
        return method.getAnnotationMirrors().stream().anyMatch(this::hasAspect);
    }

    private boolean hasAspect(AnnotationMirror annotation) {
        return ((LinkkiAspect[])annotation.getAnnotationType().asElement().getAnnotationsByType(LinkkiAspect.class)).length > 0;
    }

    private boolean hasLinkkiComponent(AnnotationMirror annotation) {
        return annotation.getAnnotationType().asElement().getAnnotation(LinkkiComponent.class) != null;
    }
}

