/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.tooling.apt.model;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;

public class AptAttribute {
    private final String name;
    private final ExecutableElement element;
    private final AnnotationValue annotationValue;

    public AptAttribute(String name, ExecutableElement element, AnnotationValue annotationValue) {
        this.name = name;
        this.element = element;
        this.annotationValue = annotationValue;
    }

    public Object getValue() {
        return this.annotationValue.getValue();
    }

    public String getName() {
        return this.name;
    }

    public ExecutableElement getElement() {
        return this.element;
    }

    public AnnotationValue getAnnotationValue() {
        return this.annotationValue;
    }

    public String toString() {
        return "AptAttribute[" + this.name + "=" + this.annotationValue + "]";
    }

    public static Optional<AptAttribute> findByName(List<AptAttribute> attributes, String name) {
        return attributes.stream().filter(it -> it.getName().equals(name)).findFirst();
    }

    public static Optional<AptAttribute> findByMetaAnnotation(List<AptAttribute> attributes, Class<? extends Annotation> metaAnnotation) {
        return attributes.stream().filter(it -> it.getElement().getAnnotation(metaAnnotation) != null).findFirst();
    }
}

