/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.zookeeper.client;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.linkedin.util.annotations.Initializer;
import org.linkedin.util.clock.Clock;
import org.linkedin.util.clock.SystemClock;
import org.linkedin.util.clock.Timespan;
import org.linkedin.util.concurrent.ConcurrentUtils;
import org.linkedin.util.exceptions.InternalException;
import org.linkedin.util.lang.LangUtils;
import org.linkedin.util.lifecycle.Destroyable;
import org.linkedin.util.lifecycle.Startable;
import org.linkedin.zookeeper.client.AbstractZKClient;
import org.linkedin.zookeeper.client.ChrootedZKClient;
import org.linkedin.zookeeper.client.IZKClient;
import org.linkedin.zookeeper.client.IZooKeeper;
import org.linkedin.zookeeper.client.IZooKeeperFactory;
import org.linkedin.zookeeper.client.LifecycleListener;
import org.linkedin.zookeeper.client.ZooKeeperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKClient
extends AbstractZKClient
implements Startable,
Destroyable {
    public static final String MODULE = ZKClient.class.getName();
    public static final Logger log = LoggerFactory.getLogger((String)MODULE);
    private IZooKeeper _zk;
    private Object _uniqueID;
    private volatile Clock _clock = SystemClock.instance();
    private volatile Timespan _reconnectTimeout = Timespan.parse((String)"20s");
    private Set<LifecycleListener> _listeners = null;
    private final Object _lock = new Object();
    private StateChangeDispatcher _stateChangeDispatcher = null;
    private ExpiredSessionRecovery _expiredSessionRecovery = null;
    private volatile State _state = State.NONE;
    private final IZooKeeperFactory _factory;

    public ZKClient(String connectString, Timespan sessionTimeout, Watcher watcher) {
        this(new ZooKeeperFactory(connectString, sessionTimeout, watcher));
    }

    public ZKClient(IZooKeeperFactory factory) {
        this(factory, null);
    }

    public ZKClient(IZooKeeperFactory factory, String chroot) {
        super(chroot);
        this._factory = factory;
    }

    public State getZKClientState() {
        return this._state;
    }

    public IZooKeeperFactory getFactory() {
        return this._factory;
    }

    public Clock getClock() {
        return this._clock;
    }

    @Initializer
    public void setClock(Clock clock) {
        this._clock = clock;
    }

    public Timespan getReconnectTimeout() {
        return this._reconnectTimeout;
    }

    @Initializer
    public void setReconnectTimeout(Timespan reconnectTimeout) {
        this._reconnectTimeout = reconnectTimeout;
    }

    public Set<LifecycleListener> getListeners() {
        return this._listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(LifecycleListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        Object object = this._lock;
        synchronized (object) {
            if (this._listeners == null || !this._listeners.contains(listener)) {
                HashSet<LifecycleListener> listeners = new HashSet<LifecycleListener>();
                if (this._listeners != null) {
                    listeners.addAll(this._listeners);
                }
                listeners.add(listener);
                this._listeners = Collections.unmodifiableSet(listeners);
                if (this._stateChangeDispatcher == null) {
                    this._stateChangeDispatcher = new StateChangeDispatcher();
                    this._stateChangeDispatcher.setDaemon(true);
                    this._stateChangeDispatcher.start();
                }
                if (this._state == State.CONNECTED) {
                    this._stateChangeDispatcher.addEvent(Arrays.asList(listener), null, State.CONNECTED);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(LifecycleListener listener) {
        Object object = this._lock;
        synchronized (object) {
            if (this._listeners != null && this._listeners.contains(listener)) {
                HashSet<LifecycleListener> listeners = new HashSet<LifecycleListener>(this._listeners);
                listeners.remove(listener);
                if (listeners.size() == 0) {
                    listeners = null;
                    if (this._stateChangeDispatcher != null) {
                        this._stateChangeDispatcher.end();
                        this._stateChangeDispatcher = null;
                    }
                }
                this._listeners = listeners == null ? null : Collections.unmodifiableSet(listeners);
            }
        }
    }

    @Override
    public IZKClient chroot(String path) {
        return new ChrootedZKClient(this, this.adjustPath(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this._lock;
        synchronized (object) {
            if (this._state != State.NONE) {
                throw new IllegalStateException("already started");
            }
            if (log.isDebugEnabled()) {
                log.debug("Starting ZKClient");
            }
            this.changeState(State.CONNECTING);
            try {
                this.createZooKeeper();
            }
            catch (InternalException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Failed to start ZKClient", (Throwable)e);
                }
                this.changeState(State.NONE);
                throw e;
            }
            catch (Throwable e) {
                if (log.isDebugEnabled()) {
                    log.debug("Failed to start ZKClient", e);
                }
                this.changeState(State.NONE);
                throw new InternalException(MODULE, e);
            }
        }
    }

    private void createZooKeeper() {
        this._uniqueID = new Object();
        this._zk = this._factory.createZooKeeper(new UniqueWatcher(this._uniqueID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(State newState) {
        Object object = this._lock;
        synchronized (object) {
            if (this._state != newState) {
                if (this._stateChangeDispatcher != null) {
                    this._stateChangeDispatcher.addEvent(this._listeners, this._state, newState);
                }
                this._state = newState;
                this._lock.notifyAll();
            }
        }
    }

    @Override
    public boolean isConnected() {
        return this._state == State.CONNECTED;
    }

    public void waitForStart() throws InterruptedException {
        try {
            this.waitForStart(null);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public void waitForStart(Timespan timeout) throws TimeoutException, InterruptedException {
        this.waitForState(State.CONNECTED, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForState(State state, Timespan timeout) throws TimeoutException, InterruptedException {
        long endTime = timeout == null ? 0L : timeout.futureTimeMillis(this._clock);
        Object object = this._lock;
        synchronized (object) {
            while (this._state != state) {
                ConcurrentUtils.awaitUntil((Clock)this._clock, (Object)this._lock, (long)endTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this._lock;
        synchronized (object) {
            block8: {
                if (this._zk != null) {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug("destroying ZKClient");
                        }
                        this.changeState(State.NONE);
                        this._zk.close();
                        this._zk = null;
                        if (this._expiredSessionRecovery != null) {
                            this._expiredSessionRecovery.interrupt();
                        }
                    }
                    catch (Throwable e) {
                        if (!log.isDebugEnabled()) break block8;
                        log.debug("ignored exception", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWatchedEvent(WatchedEvent event) {
        Object object = this._lock;
        synchronized (object) {
            if (event.getState() != null) {
                if (log.isDebugEnabled()) {
                    log.debug("event: " + event.getState());
                }
                switch (event.getState()) {
                    case SyncConnected: {
                        this.changeState(State.CONNECTED);
                        break;
                    }
                    case Disconnected: {
                        if (this._state == State.NONE) break;
                        this.changeState(State.RECONNECTING);
                        break;
                    }
                    case Expired: {
                        this._zk = null;
                        this.changeState(State.NONE);
                        log.warn("Expiration detected: trying to restart...");
                        if (this._expiredSessionRecovery != null) break;
                        this._expiredSessionRecovery = new ExpiredSessionRecovery();
                        this._expiredSessionRecovery.setDaemon(true);
                        this._expiredSessionRecovery.start();
                        break;
                    }
                    default: {
                        log.warn("unprocessed event state: " + event.getState());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IZooKeeper getZk() throws InternalException {
        Object object = this._lock;
        synchronized (object) {
            if (!this.isConnected()) {
                throw new IllegalStateException("not connected");
            }
            return this._zk;
        }
    }

    @Override
    public String getConnectString() {
        return this._factory.getConnectString();
    }

    private class ExpiredSessionRecovery
    extends Thread {
        private ExpiredSessionRecovery() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            log.info("Entering recovery mode");
            Object object = ZKClient.this._lock;
            synchronized (object) {
                try {
                    int count = 0;
                    while (ZKClient.this._state == State.NONE) {
                        try {
                            log.warn("Recovery mode: trying to reconnect to zookeeper [" + ++count + "]");
                            ZKClient.this.start();
                        }
                        catch (Throwable e) {
                            log.warn("Recovery mode: reconnect attempt failed [" + count + "]... waiting for " + ZKClient.this._reconnectTimeout, e);
                            try {
                                ZKClient.this._lock.wait(ZKClient.this._reconnectTimeout.getDurationInMilliseconds());
                            }
                            catch (InterruptedException e1) {
                                throw new RuntimeException("Recovery mode: wait interrupted... bailing out", e1);
                            }
                        }
                    }
                    return;
                }
                finally {
                    ZKClient.this._expiredSessionRecovery = null;
                    log.info("Exiting recovery mode.");
                }
            }
        }
    }

    private static class StateChangeDispatcher
    extends Thread {
        public final String MODULE = StateChangeDispatcher.class.getName();
        public final Logger log = LoggerFactory.getLogger((String)this.MODULE);
        private volatile boolean _running = true;
        private final Queue<DispatchEvent> _events = new LinkedList<DispatchEvent>();

        private StateChangeDispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.log.info("Starting StateChangeDispatcher");
            while (this._running) {
                DispatchEvent dispatchEvent = null;
                Queue<DispatchEvent> queue = this._events;
                synchronized (queue) {
                    while (this._running && this._events.isEmpty()) {
                        try {
                            this._events.wait();
                        }
                        catch (InterruptedException e) {
                            if (!this.log.isDebugEnabled()) continue;
                            this.log.debug("ignoring exception", (Throwable)e);
                        }
                    }
                    if (this._running) {
                        dispatchEvent = this._events.poll();
                    }
                }
                if (dispatchEvent == null || dispatchEvent.getListeners() == null) continue;
                for (LifecycleListener listener : dispatchEvent.getListeners()) {
                    try {
                        switch (dispatchEvent.getDispatchEventType()) {
                            case CONNECTED: {
                                listener.onConnected();
                                break;
                            }
                            case DISCONNECTED: {
                                listener.onDisconnected();
                                break;
                            }
                            default: {
                                throw new RuntimeException("not reached");
                            }
                        }
                    }
                    catch (Throwable e) {
                        this.log.warn("Exception while executing listener [" + listener + "] (ignored)", e);
                    }
                }
            }
            this.log.info("StateChangeDispatcher terminated.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void end() {
            Queue<DispatchEvent> queue = this._events;
            synchronized (queue) {
                this._running = false;
                this._events.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addEvent(Collection<LifecycleListener> listeners, State oldState, State newState) {
            Queue<DispatchEvent> queue = this._events;
            synchronized (queue) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("addEvent: " + (Object)((Object)oldState) + " => " + (Object)((Object)newState));
                }
                if (this._running) {
                    if (newState == State.CONNECTED) {
                        this._events.add(new DispatchEvent(listeners, DispatchEventType.CONNECTED));
                        this._events.notifyAll();
                    } else if (oldState == State.CONNECTED) {
                        this._events.add(new DispatchEvent(listeners, DispatchEventType.DISCONNECTED));
                        this._events.notifyAll();
                    }
                }
            }
        }

        private static class DispatchEvent {
            private final Collection<LifecycleListener> _listeners;
            private final DispatchEventType _dispatchEventType;

            private DispatchEvent(Collection<LifecycleListener> listeners, DispatchEventType dispatchEventType) {
                this._listeners = listeners;
                this._dispatchEventType = dispatchEventType;
            }

            private Collection<LifecycleListener> getListeners() {
                return this._listeners;
            }

            private DispatchEventType getDispatchEventType() {
                return this._dispatchEventType;
            }
        }

        private static enum DispatchEventType {
            CONNECTED,
            DISCONNECTED;

        }
    }

    private class UniqueWatcher
    implements Watcher {
        private final Object _uniqueID;

        private UniqueWatcher(Object uniqueID) {
            this._uniqueID = uniqueID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            Object object = ZKClient.this._lock;
            synchronized (object) {
                if (LangUtils.isEqual((Object)this._uniqueID, (Object)ZKClient.this._uniqueID)) {
                    ZKClient.this.processWatchedEvent(event);
                } else {
                    log.warn("Received an event on a different zk instance... (ignoring)");
                }
            }
        }
    }

    public static enum State {
        NONE,
        CONNECTING,
        CONNECTED,
        RECONNECTING;

    }
}

