/*
 * Decompiled with CFR 0.152.
 */
package org.libj.net.memory;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandlerFactory;
import org.libj.net.MemoryURLConnection;
import org.libj.net.MemoryURLStreamHandler;

public class Handler
extends MemoryURLStreamHandler {
    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        if (!"memory".equals(url.getProtocol())) {
            throw new MalformedURLException("Unsupported protocol: " + url.getProtocol());
        }
        if (url.getHost() != null && url.getHost().length() > 0) {
            throw new MalformedURLException("Unsupported host: " + url.getHost());
        }
        byte[] data = (byte[])idToData.get(url.getPath());
        if (data == null) {
            throw new FileNotFoundException("URL not registered: " + url);
        }
        return new MemoryURLConnection(url, data);
    }

    public static class Factory
    implements URLStreamHandlerFactory {
        private static Handler handler;

        @Override
        public Handler createURLStreamHandler(String protocol) {
            return !"memory".equals(protocol) ? null : (handler == null ? (handler = new Handler()) : handler);
        }

        static {
            if (idToData == null) {
                // empty if block
            }
        }
    }
}

