/*
 * Decompiled with CFR 0.152.
 */
package org.LatencyUtils;

import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicLongArray;
import org.LatencyUtils.MovingAverageIntervalEstimator;
import org.LatencyUtils.PauseDetector;
import org.LatencyUtils.PauseDetectorListener;

public class TimeCappedMovingAverageIntervalEstimator
extends MovingAverageIntervalEstimator {
    final long[] reportingTimes;
    final long baseTimeCap;
    final PauseTracker pauseTracker;
    long timeCap;
    static final int maxPausesToTrack = 16;
    volatile long latestPauseStartTime = 0L;
    AtomicLongArray pauseStartTimes = new AtomicLongArray(16);
    AtomicLongArray pauseLengths = new AtomicLongArray(16);
    int earliestPauseIndex = 0;
    int nextPauseRecordingIndex = 0;

    public TimeCappedMovingAverageIntervalEstimator(int requestedWindowLength, long timeCap) {
        this(requestedWindowLength, timeCap, null);
    }

    public TimeCappedMovingAverageIntervalEstimator(int requestedWindowLength, long timeCap, PauseDetector pauseDetector) {
        super(requestedWindowLength);
        this.reportingTimes = new long[this.windowLength];
        this.baseTimeCap = timeCap;
        this.timeCap = timeCap;
        this.pauseTracker = pauseDetector != null ? new PauseTracker(pauseDetector, this) : null;
        for (int i = 0; i < 16; ++i) {
            this.pauseStartTimes.set(i, Long.MAX_VALUE);
            this.pauseLengths.set(i, 0L);
        }
    }

    @Override
    public void recordInterval(long when) {
        int position = super.recordIntervalAndReturnWindowPosition(when);
        this.reportingTimes[position] = when;
    }

    @Override
    public synchronized long getEstimatedInterval(long when) {
        int positionDelta;
        long totalPauseTimeInWindow;
        long windowTimeSpan;
        long averageInterval;
        int currentPosition;
        long timeCapStartTime = when - this.timeCap;
        long earliestPauseStartTime = this.pauseStartTimes.get(this.earliestPauseIndex);
        while (earliestPauseStartTime < timeCapStartTime) {
            this.timeCap -= this.pauseLengths.get(this.earliestPauseIndex);
            timeCapStartTime = when - this.timeCap;
            this.pauseStartTimes.set(this.earliestPauseIndex, Long.MAX_VALUE);
            this.pauseLengths.set(this.earliestPauseIndex, 0L);
            this.earliestPauseIndex = (this.earliestPauseIndex + 1) % 16;
            earliestPauseStartTime = this.pauseStartTimes.get(this.earliestPauseIndex);
        }
        int earliestQualifyingWindowPosition = currentPosition = this.getCurrentPosition();
        int numberOfWindowPositionsSkipped = 0;
        while (this.intervalEndTimes[earliestQualifyingWindowPosition] < timeCapStartTime) {
            ++numberOfWindowPositionsSkipped;
            if ((earliestQualifyingWindowPosition = (int)((long)(earliestQualifyingWindowPosition + 1) & this.windowMask)) != currentPosition) continue;
        }
        if (numberOfWindowPositionsSkipped >= this.windowLength - 1) {
            return Long.MAX_VALUE;
        }
        long windowStartTime = this.intervalEndTimes[earliestQualifyingWindowPosition];
        if (windowStartTime > earliestPauseStartTime) {
            windowStartTime = earliestPauseStartTime;
        }
        if ((averageInterval = ((windowTimeSpan = when - windowStartTime) - (totalPauseTimeInWindow = this.timeCap - this.baseTimeCap)) / (long)(positionDelta = this.windowLength - (numberOfWindowPositionsSkipped + 1))) <= 0L) {
            return Long.MAX_VALUE;
        }
        return averageInterval;
    }

    synchronized void recordPause(long pauseLength, long pauseEndTime) {
        this.latestPauseStartTime = pauseEndTime - pauseLength;
        if (this.pauseStartTimes.get(this.nextPauseRecordingIndex) != Long.MAX_VALUE) {
            this.timeCap -= this.pauseLengths.get(this.nextPauseRecordingIndex);
            this.earliestPauseIndex = (this.nextPauseRecordingIndex + 1) % 16;
        }
        this.timeCap += pauseLength;
        this.pauseStartTimes.set(this.nextPauseRecordingIndex, pauseEndTime - pauseLength);
        this.pauseLengths.set(this.nextPauseRecordingIndex, pauseLength);
        this.nextPauseRecordingIndex = (this.nextPauseRecordingIndex + 1) % 16;
    }

    public void stop() {
        if (this.pauseTracker != null) {
            this.pauseTracker.stop();
        }
    }

    static class PauseTracker
    extends WeakReference<TimeCappedMovingAverageIntervalEstimator>
    implements PauseDetectorListener {
        final PauseDetector pauseDetector;

        PauseTracker(PauseDetector pauseDetector, TimeCappedMovingAverageIntervalEstimator estimator) {
            super(estimator);
            this.pauseDetector = pauseDetector;
            pauseDetector.addListener(this, true);
        }

        public void stop() {
            this.pauseDetector.removeListener(this);
        }

        @Override
        public void handlePauseEvent(long pauseLength, long pauseEndTime) {
            TimeCappedMovingAverageIntervalEstimator estimator = (TimeCappedMovingAverageIntervalEstimator)this.get();
            if (estimator != null) {
                estimator.recordPause(pauseLength, pauseEndTime);
            } else {
                this.stop();
            }
        }
    }
}

