/*
 * Decompiled with CFR 0.152.
 */
package org.LatencyUtils;

import java.util.concurrent.atomic.AtomicLong;
import org.LatencyUtils.IntervalEstimator;

public class MovingAverageIntervalEstimator
extends IntervalEstimator {
    final long[] intervalEndTimes;
    final int windowMagnitude;
    final int windowLength;
    final long windowMask;
    AtomicLong count = new AtomicLong(0L);
    volatile long forcedOrderingHelper;

    public MovingAverageIntervalEstimator(int requestedWindowLength) {
        this.windowMagnitude = (int)Math.ceil(Math.log(requestedWindowLength) / Math.log(2.0));
        this.windowLength = (int)Math.pow(2.0, this.windowMagnitude);
        this.windowMask = this.windowLength - 1;
        this.intervalEndTimes = new long[this.windowLength];
    }

    @Override
    public void recordInterval(long when) {
        this.recordIntervalAndReturnWindowPosition(when);
    }

    int recordIntervalAndReturnWindowPosition(long when) {
        long countAtSwapTime = this.count.getAndIncrement();
        int positionToSwap = (int)(countAtSwapTime & this.windowMask);
        this.intervalEndTimes[positionToSwap] = when;
        return positionToSwap;
    }

    @Override
    public long getEstimatedInterval(long when) {
        long sampledCount = this.count.get();
        if (sampledCount < (long)this.windowLength) {
            return Long.MAX_VALUE;
        }
        int earliestWindowPosition = (int)(sampledCount & this.windowMask);
        int latestWindowPosition = (int)(sampledCount + (long)this.windowLength - 1L & this.windowMask);
        long windowStartTime = this.intervalEndTimes[earliestWindowPosition];
        this.forcedOrderingHelper = 0L;
        long windowEndTime = this.intervalEndTimes[latestWindowPosition];
        long windowTimeSpan = windowEndTime - windowStartTime;
        long averageInterval = windowTimeSpan / (long)(this.windowLength - 1);
        return averageInterval;
    }

    int getCurrentPosition() {
        return (int)(this.count.get() & this.windowMask);
    }
}

