/*
 * Decompiled with CFR 0.152.
 */
package org.kopitubruk.util.json;

import java.io.Writer;
import java.util.Arrays;

class StringWriter
extends Writer {
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;
    private static final int INITIAL_SIZE = 16;
    private char[] value = new char[16];
    private int count = 0;

    @Override
    public void write(String str) {
        this.write(str, 0, str.length());
    }

    @Override
    public void write(String str, int off, int len) {
        this.ensureCapacity(this.count + len);
        str.getChars(off, off + len, this.value, this.count);
        this.count += len;
    }

    @Override
    public void write(int c) {
        this.ensureCapacity(this.count + 1);
        this.value[this.count++] = (char)c;
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        this.ensureCapacity(this.count + len);
        this.value[this.count++] = cbuf[0];
        if (len == 2) {
            this.value[this.count++] = cbuf[1];
        }
    }

    public String toString() {
        return new String(this.value, 0, this.count);
    }

    private void ensureCapacity(int capacity) {
        if (capacity - this.value.length > 0) {
            this.value = Arrays.copyOf(this.value, this.newCapacity(capacity));
        }
    }

    private int newCapacity(int capacity) {
        int newCapacity = (this.value.length << 1) + 2;
        if (newCapacity - capacity < 0) {
            newCapacity = capacity;
        }
        return newCapacity <= 0 || 0x7FFFFFF7 - newCapacity < 0 ? this.maxCapacity(capacity) : newCapacity;
    }

    private int maxCapacity(int capacity) {
        if (Integer.MAX_VALUE - capacity < 0) {
            throw new OutOfMemoryError();
        }
        return capacity > 0x7FFFFFF7 ? capacity : 0x7FFFFFF7;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

