/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.EnterpriseManagedSupport;
import org.kohsuke.github.GHDiscussion;
import org.kohsuke.github.GHExternalGroup;
import org.kohsuke.github.GHExternalGroupPage;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.HttpException;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Refreshable;
import org.kohsuke.github.Requester;
import org.kohsuke.github.internal.EnumUtils;

public class GHTeam
extends GHObject
implements Refreshable {
    private static final String EXTERNAL_GROUPS = "/external-groups";
    private String description;
    private String htmlUrl;
    private String name;
    private GHOrganization organization;
    private String permission;
    private String privacy;
    private String slug;

    public void add(GHRepository r) throws IOException {
        this.add(r, (GHOrganization.RepositoryRole)null);
    }

    public void add(GHRepository r, GHOrganization.RepositoryRole permission) throws IOException {
        ((Requester)((Requester)((Requester)this.root().createRequest().method("PUT")).with("permission", (String)Optional.ofNullable(permission).map(GHOrganization.RepositoryRole::toString).orElse(null))).withUrlPath(this.api("/repos/" + r.getOwnerName() + "/" + r.getName()), new String[0])).send();
    }

    public void add(GHUser u) throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("PUT")).withUrlPath(this.api("/memberships/" + u.getLogin()), new String[0])).send();
    }

    public void add(GHUser user, Role role) throws IOException {
        ((Requester)((Requester)((Requester)this.root().createRequest().method("PUT")).with("role", role)).withUrlPath(this.api("/memberships/" + user.getLogin()), new String[0])).send();
    }

    public GHExternalGroup connectToExternalGroup(GHExternalGroup group) throws IOException {
        return this.connectToExternalGroup(group.getId());
    }

    public GHExternalGroup connectToExternalGroup(long group_id) throws IOException {
        try {
            return ((Requester)((Requester)((Requester)this.root().createRequest().method("PATCH")).with("group_id", group_id)).withUrlPath(this.publicApi(EXTERNAL_GROUPS), new String[0])).fetch(GHExternalGroup.class).wrapUp(this.getOrganization());
        }
        catch (HttpException e) {
            throw EnterpriseManagedSupport.forOrganization(this.getOrganization()).filterException(e, "Could not connect team to external group").orElse(e);
        }
    }

    public GHDiscussion.Creator createDiscussion(String title) throws IOException {
        return (GHDiscussion.Creator)GHDiscussion.create(this).title(title);
    }

    public void delete() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("DELETE")).withUrlPath(this.api(""), new String[0])).send();
    }

    public void deleteExternalGroupConnection() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("DELETE")).withUrlPath(this.publicApi(EXTERNAL_GROUPS), new String[0])).send();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GHTeam ghTeam = (GHTeam)o;
        return Objects.equals(this.name, ghTeam.name) && Objects.equals(this.getUrl(), ghTeam.getUrl()) && Objects.equals(this.permission, ghTeam.permission) && Objects.equals(this.slug, ghTeam.slug) && Objects.equals(this.description, ghTeam.description) && Objects.equals(this.privacy, ghTeam.privacy);
    }

    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public GHDiscussion getDiscussion(long discussionNumber) throws IOException {
        return GHDiscussion.read(this, discussionNumber);
    }

    public List<GHExternalGroup> getExternalGroups() throws IOException {
        try {
            return Collections.unmodifiableList(Arrays.asList(((Requester)((Requester)this.root().createRequest().method("GET")).withUrlPath(this.publicApi(EXTERNAL_GROUPS), new String[0])).fetch(GHExternalGroupPage.class).getGroups()));
        }
        catch (HttpException e) {
            throw EnterpriseManagedSupport.forOrganization(this.getOrganization()).filterException(e, "Could not retrieve team external groups").orElse(e);
        }
    }

    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    public Set<GHUser> getMembers() throws IOException {
        return this.listMembers().toSet();
    }

    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHOrganization getOrganization() throws IOException {
        this.refresh(this.organization);
        return this.organization;
    }

    public String getPermission() {
        return this.permission;
    }

    public Privacy getPrivacy() {
        return EnumUtils.getNullableEnumOrDefault(Privacy.class, this.privacy, Privacy.UNKNOWN);
    }

    public Map<String, GHRepository> getRepositories() {
        TreeMap<String, GHRepository> m = new TreeMap<String, GHRepository>();
        for (GHRepository r : this.listRepositories()) {
            m.put(r.getName(), r);
        }
        return m;
    }

    public String getSlug() {
        return this.slug;
    }

    public boolean hasMember(GHUser user) {
        try {
            ((Requester)this.root().createRequest().withUrlPath(this.api("/memberships/" + user.getLogin()), new String[0])).send();
            return true;
        }
        catch (IOException ignore) {
            return false;
        }
    }

    public int hashCode() {
        return Objects.hash(this.name, this.getUrl(), this.permission, this.slug, this.description, this.privacy);
    }

    public PagedIterable<GHTeam> listChildTeams() {
        return ((Requester)this.root().createRequest().withUrlPath(this.api("/teams"), new String[0])).toIterable(GHTeam[].class, item -> item.wrapUp(this.organization));
    }

    @Nonnull
    public PagedIterable<GHDiscussion> listDiscussions() {
        return GHDiscussion.readAll(this);
    }

    public PagedIterable<GHUser> listMembers() {
        return this.listMembers("all");
    }

    public PagedIterable<GHUser> listMembers(Role role) {
        return this.listMembers(GitHubRequest.transformEnum(role));
    }

    public PagedIterable<GHUser> listMembers(String role) {
        return ((Requester)((Requester)this.root().createRequest().withUrlPath(this.api("/members"), new String[0])).with("role", role)).toIterable(GHUser[].class, null);
    }

    public PagedIterable<GHRepository> listRepositories() {
        return ((Requester)this.root().createRequest().withUrlPath(this.api("/repos"), new String[0])).toIterable(GHRepository[].class, null);
    }

    @Override
    public void refresh() throws IOException {
        ((Requester)this.root().createRequest().withUrlPath(this.api(""), new String[0])).fetchInto(this).wrapUp(this.root());
    }

    public void remove(GHRepository r) throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("DELETE")).withUrlPath(this.api("/repos/" + r.getOwnerName() + "/" + r.getName()), new String[0])).send();
    }

    public void remove(GHUser u) throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("DELETE")).withUrlPath(this.api("/memberships/" + u.getLogin()), new String[0])).send();
    }

    public void setDescription(String description) throws IOException {
        ((Requester)((Requester)((Requester)this.root().createRequest().method("PATCH")).with("description", description)).withUrlPath(this.api(""), new String[0])).send();
    }

    public void setPrivacy(Privacy privacy) throws IOException {
        ((Requester)((Requester)((Requester)this.root().createRequest().method("PATCH")).with("privacy", privacy)).withUrlPath(this.api(""), new String[0])).send();
    }

    private String api(String tail) {
        if (this.organization == null) {
            URL url = Objects.requireNonNull(this.getUrl(), "Missing instance URL!");
            return StringUtils.prependIfMissing((String)url.toString().replace(this.root().getApiUrl(), ""), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + tail;
        }
        return "/organizations/" + this.organization.getId() + "/team/" + this.getId() + tail;
    }

    private String publicApi(String tail) throws IOException {
        return "/orgs/" + this.getOrganization().login + "/teams/" + this.getSlug() + tail;
    }

    GHTeam wrapUp(GHOrganization owner) {
        this.organization = owner;
        return this;
    }

    GHTeam wrapUp(GitHub root) {
        return this.wrapUp(this.organization);
    }

    public static enum Privacy {
        CLOSED,
        SECRET,
        UNKNOWN;

    }

    public static enum Role {
        MAINTAINER,
        MEMBER;

    }
}

