/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github.internal;

import okhttp3.OkHttpClient;
import org.kohsuke.github.connector.GitHubConnector;
import org.kohsuke.github.extras.HttpClientGitHubConnector;
import org.kohsuke.github.extras.okhttp3.OkHttpGitHubConnector;

public final class DefaultGitHubConnector {
    public static GitHubConnector create() {
        String defaultConnectorProperty = System.getProperty("test.github.connector", "default");
        return DefaultGitHubConnector.create(defaultConnectorProperty);
    }

    static GitHubConnector create(String defaultConnectorProperty) {
        if (defaultConnectorProperty.equalsIgnoreCase("okhttp")) {
            return new OkHttpGitHubConnector(new OkHttpClient.Builder().build());
        }
        if (defaultConnectorProperty.equalsIgnoreCase("httpclient")) {
            return new HttpClientGitHubConnector();
        }
        if (defaultConnectorProperty.equalsIgnoreCase("default")) {
            return new HttpClientGitHubConnector();
        }
        throw new IllegalStateException("Property 'test.github.connector' must reference a valid built-in connector - okhttp, httpclient, or default.");
    }

    private DefaultGitHubConnector() {
    }
}

