/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import java.net.URL;
import java.time.Instant;
import java.util.Date;
import org.kohsuke.github.GHCommentAuthorAssociation;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHubBridgeAdapterObject;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.internal.EnumUtils;

public class GHRepositoryDiscussion
extends GHObject {
    private String activeLockReason;
    private String answerChosenAt;
    private GHUser answerChosenBy;
    private String answerHtmlUrl;
    private GHCommentAuthorAssociation authorAssociation;
    private String body;
    private Category category;
    private int comments;
    private String htmlUrl;
    private boolean locked;
    private int number;
    private String state;
    private String timelineUrl;
    private String title;
    private GHUser user;

    public String getActiveLockReason() {
        return this.activeLockReason;
    }

    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getAnswerChosenAt() {
        return GitHubClient.parseInstant(this.answerChosenAt);
    }

    public GHUser getAnswerChosenBy() {
        return this.root().intern(this.answerChosenBy);
    }

    public URL getAnswerHtmlUrl() {
        return GitHubClient.parseURL(this.answerHtmlUrl);
    }

    public GHCommentAuthorAssociation getAuthorAssociation() {
        return this.authorAssociation;
    }

    public String getBody() {
        return this.body;
    }

    public Category getCategory() {
        return this.category;
    }

    public int getComments() {
        return this.comments;
    }

    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    public int getNumber() {
        return this.number;
    }

    public State getState() {
        return EnumUtils.getEnumOrDefault(State.class, this.state, State.UNKNOWN);
    }

    public String getTimelineUrl() {
        return this.timelineUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public GHUser getUser() {
        return this.root().intern(this.user);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public static class Category
    extends GitHubBridgeAdapterObject {
        private String createdAt;
        private String description;
        private String emoji;
        private long id;
        private boolean isAnswerable;
        private String name;
        private String nodeId;
        private long repositoryId;
        private String slug;
        private String updatedAt;

        @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
        public Instant getCreatedAt() {
            return GitHubClient.parseInstant(this.createdAt);
        }

        public String getDescription() {
            return this.description;
        }

        public String getEmoji() {
            return this.emoji;
        }

        public long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public long getRepositoryId() {
            return this.repositoryId;
        }

        public String getSlug() {
            return this.slug;
        }

        @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
        public Instant getUpdatedAt() {
            return GitHubClient.parseInstant(this.updatedAt);
        }

        public boolean isAnswerable() {
            return this.isAnswerable;
        }
    }

    public static enum State {
        LOCKED,
        OPEN,
        UNKNOWN;

    }
}

