/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Instant;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHVerification;
import org.kohsuke.github.GitHubBridgeAdapterObject;
import org.kohsuke.github.GitUser;

@SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD", "UWF_UNWRITTEN_FIELD"}, justification="JSON API")
public class GitCommit
extends GitHubBridgeAdapterObject {
    private GHRepository owner;
    private String sha;
    private String node_id;
    private String url;
    private String html_url;
    private GitUser author;
    private GitUser committer;
    private String message;
    private GHVerification verification;
    private Tree tree;
    private List<GHCommit.Parent> parents;

    public GitCommit() {
    }

    GitCommit(GitCommit commit) {
        this.owner = commit.getOwner();
        this.sha = commit.getSha();
        this.node_id = commit.getNodeId();
        this.url = commit.getUrl();
        this.html_url = commit.getHtmlUrl();
        this.author = commit.getAuthor();
        this.committer = commit.getCommitter();
        this.message = commit.getMessage();
        this.verification = commit.getVerification();
        this.tree = commit.getTree();
        this.parents = commit.getParents();
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHRepository getOwner() {
        return this.owner;
    }

    public String getSHA1() {
        return this.sha;
    }

    public String getSha() {
        return this.sha;
    }

    public String getNodeId() {
        return this.node_id;
    }

    public String getUrl() {
        return this.url;
    }

    public String getHtmlUrl() {
        return this.html_url;
    }

    public GitUser getAuthor() {
        return this.author;
    }

    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getAuthoredDate() {
        return this.author.getDate();
    }

    public GitUser getCommitter() {
        return this.committer;
    }

    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getCommitDate() {
        return this.committer.getDate();
    }

    public String getMessage() {
        return this.message;
    }

    public GHVerification getVerification() {
        return this.verification;
    }

    Tree getTree() {
        return this.tree;
    }

    public String getTreeSHA1() {
        return this.tree.getSha();
    }

    public String getTreeUrl() {
        return this.tree.getUrl();
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="acceptable")
    List<GHCommit.Parent> getParents() {
        return this.parents;
    }

    public List<String> getParentSHA1s() {
        if (this.parents == null || this.parents.size() == 0) {
            return Collections.emptyList();
        }
        return new AbstractList<String>(){

            @Override
            public String get(int index) {
                return GitCommit.this.parents.get((int)index).sha;
            }

            @Override
            public int size() {
                return GitCommit.this.parents.size();
            }
        };
    }

    GitCommit wrapUp(GHRepository owner) {
        this.owner = owner;
        return this;
    }

    GHCommit toGHCommit() {
        return new GHCommit(new GHCommit.ShortInfo(this));
    }

    static class Tree {
        String url;
        String sha;

        Tree() {
        }

        public String getUrl() {
            return this.url;
        }

        public String getSha() {
            return this.sha;
        }
    }
}

