/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.kohsuke.github.GHAsset;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHReleaseUpdater;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;

public class GHRelease
extends GHObject {
    GHRepository owner;
    private String html_url;
    private String assets_url;
    private List<GHAsset> assets;
    private String upload_url;
    private String tag_name;
    private String target_commitish;
    private String name;
    private String body;
    private boolean draft;
    private boolean prerelease;
    private String publishedAt;
    private String tarball_url;
    private String zipball_url;
    private String discussion_url;

    public String getDiscussionUrl() {
        return this.discussion_url;
    }

    public String getAssetsUrl() {
        return this.assets_url;
    }

    public String getBody() {
        return this.body;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.html_url);
    }

    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHRepository getOwner() {
        return this.owner;
    }

    public boolean isPrerelease() {
        return this.prerelease;
    }

    @Deprecated
    public Date getPublished_at() {
        return Date.from(this.getPublishedAt());
    }

    public Instant getPublishedAt() {
        return GitHubClient.parseInstant(this.publishedAt);
    }

    public String getTagName() {
        return this.tag_name;
    }

    public String getTargetCommitish() {
        return this.target_commitish;
    }

    public String getUploadUrl() {
        return this.upload_url;
    }

    public String getZipballUrl() {
        return this.zipball_url;
    }

    public String getTarballUrl() {
        return this.tarball_url;
    }

    GHRelease wrap(GHRepository owner) {
        this.owner = owner;
        return this;
    }

    static GHRelease[] wrap(GHRelease[] releases, GHRepository owner) {
        for (GHRelease release : releases) {
            release.wrap(owner);
        }
        return releases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GHAsset uploadAsset(File file, String contentType) throws IOException {
        try (FileInputStream s = new FileInputStream(file);){
            GHAsset gHAsset = this.uploadAsset(file.getName(), s, contentType);
            return gHAsset;
        }
    }

    public GHAsset uploadAsset(String filename, InputStream stream, String contentType) throws IOException {
        Requester builder = (Requester)this.owner.root().createRequest().method("POST");
        Object url = this.getUploadUrl();
        int endIndex = ((String)url).indexOf(123);
        if (endIndex != -1) {
            url = ((String)url).substring(0, endIndex);
        }
        url = (String)url + "?name=" + URLEncoder.encode(filename, "UTF-8");
        return ((Requester)((Requester)((Requester)builder.contentType(contentType)).with(stream)).withUrlPath((String)url, new String[0])).fetch(GHAsset.class).wrap(this);
    }

    public List<GHAsset> getAssets() {
        return Collections.unmodifiableList(this.assets);
    }

    public PagedIterable<GHAsset> listAssets() {
        Requester builder = this.owner.root().createRequest();
        return ((Requester)builder.withUrlPath(this.getApiTailUrl("assets"), new String[0])).toIterable(GHAsset[].class, item -> item.wrap(this));
    }

    public void delete() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("DELETE")).withUrlPath(this.owner.getApiTailUrl("releases/" + this.getId()), new String[0])).send();
    }

    public GHReleaseUpdater update() {
        return new GHReleaseUpdater(this);
    }

    private String getApiTailUrl(String end) {
        return this.owner.getApiTailUrl(String.format("releases/%s/%s", this.getId(), end));
    }
}

