/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.service.um.useradmin.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;
import org.osgi.framework.InvalidSyntaxException;

public class LDAPQuery {
    private static final char WILDCARD = '\uffff';
    private static final String WILDCARD_STRING = new String(new char[]{'\uffff'});
    private static final String NULL = "Null query";
    private static final String GARBAGE = "Trailing garbage";
    private static final String MALFORMED = "Malformed query";
    private static final String EMPTY = "Empty list";
    private static final String SUBEXPR = "No subexpression";
    private static final String OPERATOR = "Undefined operator";
    private static final int EQ = 0;
    private static final int LE = 1;
    private static final int GE = 2;
    private static final int APPROX = 3;
    private static Class classBigDecimal;
    private static Constructor consBigDecimal;
    private static Method compBigDecimal;
    boolean val;
    String tail;
    Dictionary prop;
    static /* synthetic */ Class class$java$lang$String;

    public static void check(String q) throws InvalidSyntaxException {
        LDAPQuery.query(q, null);
    }

    public static boolean query(String q, Dictionary p) throws InvalidSyntaxException {
        LDAPQuery lq = new LDAPQuery(q, p);
        lq.doQuery();
        if (lq.tail.length() > 0) {
            lq.error(GARBAGE);
        }
        return lq.val;
    }

    LDAPQuery(String q, Dictionary p) throws InvalidSyntaxException {
        if (q == null || q.length() == 0) {
            this.error(NULL);
        }
        this.tail = q;
        this.prop = p;
    }

    void doQuery() throws InvalidSyntaxException {
        if (this.tail.length() < 3 || !this.prefix("(")) {
            this.error(MALFORMED);
        }
        switch (this.tail.charAt(0)) {
            case '&': {
                this.doAnd();
                break;
            }
            case '|': {
                this.doOr();
                break;
            }
            case '!': {
                this.doNot();
                break;
            }
            default: {
                this.doSimple();
            }
        }
        if (!this.prefix(")")) {
            this.error(MALFORMED);
        }
    }

    private void doAnd() throws InvalidSyntaxException {
        this.tail = this.tail.substring(1);
        boolean val1 = true;
        if (!this.tail.startsWith("(")) {
            this.error(EMPTY);
        }
        do {
            this.doQuery();
            if (this.val) continue;
            val1 = false;
        } while (this.tail.startsWith("("));
        this.val = val1;
    }

    private void doOr() throws InvalidSyntaxException {
        this.tail = this.tail.substring(1);
        boolean val1 = false;
        if (!this.tail.startsWith("(")) {
            this.error(EMPTY);
        }
        do {
            this.doQuery();
            if (!this.val) continue;
            val1 = true;
        } while (this.tail.startsWith("("));
        this.val = val1;
    }

    private void doNot() throws InvalidSyntaxException {
        this.tail = this.tail.substring(1);
        if (!this.tail.startsWith("(")) {
            this.error(SUBEXPR);
        }
        this.doQuery();
        this.val = !this.val;
    }

    private void doSimple() throws InvalidSyntaxException {
        int op = 0;
        Object attr = this.getAttr();
        if (this.prefix("=")) {
            op = 0;
        } else if (this.prefix("<=")) {
            op = 1;
        } else if (this.prefix(">=")) {
            op = 2;
        } else if (this.prefix("~=")) {
            op = 3;
        } else {
            this.error(OPERATOR);
        }
        this.val = this.compare(attr, op, this.getValue());
    }

    private boolean prefix(String pre) {
        if (!this.tail.startsWith(pre)) {
            return false;
        }
        this.tail = this.tail.substring(pre.length());
        return true;
    }

    private Object getAttr() {
        int ix;
        int len = this.tail.length();
        block3: for (ix = 0; ix < len; ++ix) {
            switch (this.tail.charAt(ix)) {
                case '(': 
                case ')': 
                case '*': 
                case '<': 
                case '=': 
                case '>': 
                case '\\': 
                case '~': {
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
        }
        String attr = this.tail.substring(0, ix);
        this.tail = this.tail.substring(ix);
        return this.prop != null ? this.prop.get(attr) : null;
    }

    private String getValue() {
        int ix;
        StringBuffer sb = new StringBuffer();
        int len = this.tail.length();
        block5: for (ix = 0; ix < len; ++ix) {
            char c = this.tail.charAt(ix);
            switch (c) {
                case '(': 
                case ')': {
                    break block5;
                }
                case '*': {
                    sb.append('\uffff');
                    continue block5;
                }
                case '\\': {
                    if (ix == len - 1) break block5;
                    sb.append(this.tail.charAt(++ix));
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        this.tail = this.tail.substring(ix);
        return sb.toString();
    }

    private void error(String m) throws InvalidSyntaxException {
        throw new InvalidSyntaxException(m, this.tail);
    }

    private boolean compare(Object obj, int op, String s) {
        if (obj == null) {
            return false;
        }
        if (op == 0 && s.equals(WILDCARD_STRING)) {
            return true;
        }
        try {
            if (obj instanceof String) {
                return LDAPQuery.compareString((String)obj, op, s);
            }
            if (obj instanceof Character) {
                return LDAPQuery.compareString(obj.toString(), op, s);
            }
            if (obj instanceof Boolean) {
                if (op == 1 || op == 2) {
                    return false;
                }
                return ((Boolean)obj).equals(new Boolean(s));
            }
            if (obj instanceof Number) {
                if (obj instanceof Byte) {
                    switch (op) {
                        case 1: {
                            return (Byte)obj <= Byte.parseByte(s);
                        }
                        case 2: {
                            return (Byte)obj >= Byte.parseByte(s);
                        }
                    }
                    return new Byte(s).equals(obj);
                }
                if (obj instanceof Integer) {
                    switch (op) {
                        case 1: {
                            return (Integer)obj <= Integer.parseInt(s);
                        }
                        case 2: {
                            return (Integer)obj >= Integer.parseInt(s);
                        }
                    }
                    return new Integer(s).equals(obj);
                }
                if (obj instanceof Short) {
                    switch (op) {
                        case 1: {
                            return (Short)obj <= Short.parseShort(s);
                        }
                        case 2: {
                            return (Short)obj >= Short.parseShort(s);
                        }
                    }
                    return new Short(s).equals(obj);
                }
                if (obj instanceof Long) {
                    switch (op) {
                        case 1: {
                            return (Long)obj <= Long.parseLong(s);
                        }
                        case 2: {
                            return (Long)obj >= Long.parseLong(s);
                        }
                    }
                    return new Long(s).equals(obj);
                }
                if (obj instanceof Float) {
                    switch (op) {
                        case 1: {
                            return ((Float)obj).floatValue() <= new Float(s).floatValue();
                        }
                        case 2: {
                            return ((Float)obj).floatValue() >= new Float(s).floatValue();
                        }
                    }
                    return new Float(s).equals(obj);
                }
                if (obj instanceof Double) {
                    switch (op) {
                        case 1: {
                            return (Double)obj <= new Double(s);
                        }
                        case 2: {
                            return (Double)obj >= new Double(s);
                        }
                    }
                    return new Double(s).equals(obj);
                }
                if (obj instanceof BigInteger) {
                    int c = ((BigInteger)obj).compareTo(new BigInteger(s));
                    switch (op) {
                        case 1: {
                            return c <= 0;
                        }
                        case 2: {
                            return c >= 0;
                        }
                    }
                    return c == 0;
                }
                if (classBigDecimal != null && classBigDecimal.isInstance(obj)) {
                    Object n = consBigDecimal.newInstance(s);
                    int c = (Integer)compBigDecimal.invoke(obj, n);
                    switch (op) {
                        case 1: {
                            return c <= 0;
                        }
                        case 2: {
                            return c >= 0;
                        }
                    }
                    return c == 0;
                }
            } else if (obj instanceof Vector) {
                Enumeration e = ((Vector)obj).elements();
                while (e.hasMoreElements()) {
                    if (!this.compare(e.nextElement(), op, s)) continue;
                    return true;
                }
            } else if (obj.getClass().isArray()) {
                int len = Array.getLength(obj);
                for (int i = 0; i < len; ++i) {
                    if (!this.compare(Array.get(obj, i), op, s)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    static boolean compareString(String s1, int op, String s2) {
        switch (op) {
            case 1: {
                return s1.compareTo(s2) <= 0;
            }
            case 2: {
                return s1.compareTo(s2) >= 0;
            }
            case 0: {
                return LDAPQuery.patSubstr(s1, s2);
            }
            case 3: {
                return LDAPQuery.fixupString(s2).equals(LDAPQuery.fixupString(s1));
            }
        }
        return false;
    }

    static String fixupString(String s) {
        StringBuffer sb = new StringBuffer();
        int len = s.length();
        boolean isStart = true;
        boolean isWhite = false;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) {
                isWhite = true;
                continue;
            }
            if (!isStart && isWhite) {
                sb.append(' ');
            }
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
            }
            sb.append(c);
            isStart = false;
            isWhite = false;
        }
        return sb.toString();
    }

    static boolean patSubstr(String s, String pat) {
        if (s == null) {
            return false;
        }
        if (pat.length() == 0) {
            return s.length() == 0;
        }
        if (pat.charAt(0) == '\uffff') {
            pat = pat.substring(1);
            while (true) {
                if (LDAPQuery.patSubstr(s, pat)) {
                    return true;
                }
                if (s.length() == 0) {
                    return false;
                }
                s = s.substring(1);
            }
        }
        if (s.length() == 0 || s.charAt(0) != pat.charAt(0)) {
            return false;
        }
        return LDAPQuery.patSubstr(s.substring(1), pat.substring(1));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            classBigDecimal = Class.forName("java.math.BigDecimal");
            consBigDecimal = classBigDecimal.getConstructor(class$java$lang$String == null ? (class$java$lang$String = LDAPQuery.class$("java.lang.String")) : class$java$lang$String);
            compBigDecimal = classBigDecimal.getMethod("compareTo", classBigDecimal);
        }
        catch (Exception ignore) {
            classBigDecimal = null;
        }
    }
}

