/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.service.um.useradmin.impl;

import java.util.Vector;
import org.knopflerfish.service.log.LogRef;
import org.osgi.framework.BundleContext;

final class EventQueue
implements Runnable {
    private Thread thread;
    private final Object threadLock = new Object();
    private LogRef log;
    private Vector queue = new Vector();

    EventQueue(BundleContext bc) {
        this.log = new LogRef(bc);
    }

    public void run() {
        Runnable job;
        while ((job = this.dequeue()) != null) {
            try {
                job.run();
                continue;
            }
            catch (Throwable t) {
                this.log.error("Error while executing event dispatch job ", t);
                continue;
            }
            break;
        }
        return;
    }

    public synchronized void enqueue(Runnable job) {
        if (job == null) {
            throw new IllegalArgumentException("null job");
        }
        this.queue.addElement(job);
        this.attachNewThreadIfNeccesary();
        this.notifyAll();
    }

    private synchronized Runnable dequeue() {
        if (this.queue.isEmpty()) {
            try {
                this.wait(5000L);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
        }
        if (this.queue.isEmpty()) {
            this.detachCurrentThread();
            return null;
        }
        Runnable job = (Runnable)this.queue.elementAt(0);
        this.queue.removeElementAt(0);
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void attachNewThreadIfNeccesary() {
        Object object = this.threadLock;
        synchronized (object) {
            if (this.thread == null) {
                this.thread = new Thread((Runnable)this, "UserAdminEventDispatchThread");
                this.thread.setPriority(5);
                this.thread.setDaemon(true);
                this.thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detachCurrentThread() {
        Object object = this.threadLock;
        synchronized (object) {
            this.thread = null;
        }
    }
}

