/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.service.console;

import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public class Util {
    private static final String BLANKS = "                                                                  ";

    public static void selectBundles(Bundle[] bundles, String[] selection) {
        if (selection != null) {
            for (int i = 0; i < bundles.length; ++i) {
                int j;
                String bn = Util.shortName(bundles[i]);
                String l = bundles[i].getLocation();
                for (j = 0; j < selection.length; ++j) {
                    String s;
                    try {
                        long id = Long.parseLong(selection[j]);
                        if (bundles[i].getBundleId() == id) {
                            break;
                        }
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    if (bn.equals(selection[j]) || l.equals(selection[j]) || (selection[j].startsWith("*") ? bn.endsWith(s = selection[j].substring(1)) || l.endsWith(s) : (selection[j].endsWith("*") ? bn.startsWith(s = selection[j].substring(0, selection[j].length() - 1)) || s.indexOf(58) != -1 && l.startsWith(s) : l.endsWith("/" + selection[j] + ".jar") || l.endsWith("\\" + selection[j] + ".jar")))) break;
                }
                if (j != selection.length) continue;
                bundles[i] = null;
            }
        }
    }

    public static void sortBundles(Bundle[] b, boolean longName) {
        int x;
        int l = x = b.length;
        while (x > 0) {
            x = 0;
            String p = null;
            if (b[0] != null) {
                p = longName ? b[0].getLocation() : Util.shortName(b[0]);
            }
            for (int i = 1; i < l; ++i) {
                String n = null;
                if (b[i] != null) {
                    String string = n = longName ? b[i].getLocation() : Util.shortName(b[i]);
                }
                if (n != null && (p == null || p.compareTo(n) > 0)) {
                    x = i - 1;
                    Bundle t = b[x];
                    b[x] = b[i];
                    b[i] = t;
                    continue;
                }
                p = n;
            }
        }
    }

    public static void sortBundlesId(Bundle[] b) {
        int x;
        int l = x = b.length;
        while (x > 0) {
            x = 0;
            long p = b[0] != null ? b[0].getBundleId() : Long.MAX_VALUE;
            for (int i = 1; i < l; ++i) {
                long n;
                long l2 = n = b[i] != null ? b[i].getBundleId() : Long.MAX_VALUE;
                if (p > n) {
                    x = i - 1;
                    Bundle t = b[x];
                    b[x] = b[i];
                    b[i] = t;
                    continue;
                }
                p = n;
            }
        }
    }

    public static void sortBundlesTime(Bundle[] b) {
        int x;
        int l = x = b.length;
        while (x > 0) {
            x = 0;
            long p = b[0] != null ? b[0].getLastModified() : Long.MAX_VALUE;
            for (int i = 1; i < l; ++i) {
                long n;
                long l2 = n = b[i] != null ? b[i].getLastModified() : Long.MAX_VALUE;
                if (p > n) {
                    x = i - 1;
                    Bundle t = b[x];
                    b[x] = b[i];
                    b[i] = t;
                    continue;
                }
                p = n;
            }
        }
    }

    public static String shortName(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        String n = (String)bundle.getHeaders().get("Bundle-Name");
        if (n == null) {
            n = bundle.getLocation();
            int x = n.lastIndexOf(47);
            int y = n.lastIndexOf(92);
            if (y > x) {
                x = y;
            }
            if (x != -1) {
                n = n.substring(x + 1);
            }
            if (n.endsWith(".jar")) {
                n = n.substring(0, n.length() - 4);
            }
        }
        return n;
    }

    public static String showState(Bundle bundle) {
        switch (bundle.getState()) {
            case 2: {
                return "installed   ";
            }
            case 4: {
                return "resolved    ";
            }
            case 8: {
                return "starting    ";
            }
            case 32: {
                return "active      ";
            }
            case 16: {
                return "stopping    ";
            }
            case 1: {
                return "uninstalled ";
            }
        }
        return "ILLEGAL <" + bundle.getState() + "> ";
    }

    public static String showId(Bundle bundle) {
        return Util.showRight(5, String.valueOf(bundle.getBundleId())) + " ";
    }

    public static String showServiceClasses(ServiceReference sr) {
        StringBuffer sb = new StringBuffer();
        String[] c = (String[])sr.getProperty("objectClass");
        if (c.length >= 2) {
            sb.append("[");
        }
        for (int i = 0; i < c.length; ++i) {
            int x;
            if (i > 0) {
                sb.append(",");
            }
            sb.append((x = c[i].lastIndexOf(46)) != -1 ? c[i].substring(x + 1) : c[i]);
        }
        if (c.length >= 2) {
            sb.append("]");
        }
        return sb.toString();
    }

    public static String showObject(Object o) {
        if (o == null) {
            return "null";
        }
        if (o.getClass().isArray()) {
            StringBuffer sb = new StringBuffer();
            int len = Array.getLength(o);
            sb.append("[");
            if (len > 0) {
                sb.append(Util.showObject(Array.get(o, 0)));
            }
            for (int i = 1; i < len; ++i) {
                sb.append(", " + Util.showObject(Array.get(o, i)));
            }
            sb.append("]");
            o = sb;
        } else if (o instanceof Vector) {
            StringBuffer sb = new StringBuffer();
            Enumeration e = ((Vector)o).elements();
            sb.append("[");
            if (e.hasMoreElements()) {
                sb.append(Util.showObject(e.nextElement()));
            }
            while (e.hasMoreElements()) {
                sb.append(", " + Util.showObject(e.nextElement()));
            }
            sb.append("]");
            o = sb;
        }
        return o.toString();
    }

    public static String showLeft(int width, String str) {
        if (str.length() < width) {
            return str + BLANKS.substring(0, width - str.length());
        }
        return str.substring(0, width);
    }

    public static String showRight(int width, String str) {
        if (str.length() < width) {
            return BLANKS.substring(0, width - str.length()) + str;
        }
        return str.substring(0, width);
    }
}

