/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth.ciba;

import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.keycloak.testsuite.util.oauth.AbstractHttpPostRequest;
import org.keycloak.testsuite.util.oauth.AbstractOAuthClient;
import org.keycloak.testsuite.util.oauth.AccessTokenResponse;

public class BackchannelAuthenticationTokenRequest
extends AbstractHttpPostRequest<BackchannelAuthenticationTokenRequest, AccessTokenResponse> {
    private final String authReqId;

    BackchannelAuthenticationTokenRequest(String authReqId, AbstractOAuthClient<?> client) {
        super(client);
        this.authReqId = authReqId;
    }

    @Override
    protected String getEndpoint() {
        return this.client.getEndpoints().getToken();
    }

    @Override
    protected void initRequest() {
        this.parameter("grant_type", "urn:openid:params:grant-type:ciba");
        this.parameter("auth_req_id", this.authReqId);
    }

    @Override
    protected AccessTokenResponse toResponse(CloseableHttpResponse response) throws IOException {
        return new AccessTokenResponse(response);
    }
}

