/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth;

import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.testsuite.util.oauth.AbstractHttpResponse;

public class JwksResponse
extends AbstractHttpResponse {
    private JSONWebKeySet jwks;

    JwksResponse(CloseableHttpResponse response) throws IOException {
        super(response);
    }

    @Override
    protected void parseContent() throws IOException {
        this.jwks = this.asJson(JSONWebKeySet.class);
    }

    public JSONWebKeySet getJwks() {
        return this.jwks;
    }

    @Override
    protected void assertJsonContentType() throws IOException {
        String contentType = this.getContentType();
        if (contentType == null || !contentType.startsWith("application/jwk-set+json") && !contentType.startsWith("application/json")) {
            throw new IOException("Invalid content type retrieved. Status: " + this.getStatusCode() + ", contentType: " + contentType);
        }
    }
}

