/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth;

import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.keycloak.testsuite.util.oauth.AbstractHttpPostRequest;
import org.keycloak.testsuite.util.oauth.AbstractOAuthClient;
import org.keycloak.testsuite.util.oauth.LogoutResponse;

public class LogoutRequest
extends AbstractHttpPostRequest<LogoutRequest, LogoutResponse> {
    private final String refreshToken;

    LogoutRequest(String refreshToken, AbstractOAuthClient<?> client) {
        super(client);
        this.refreshToken = refreshToken;
    }

    @Override
    protected String getEndpoint() {
        return this.client.getEndpoints().getLogout();
    }

    @Override
    protected void initRequest() {
        this.parameter("refresh_token", this.refreshToken);
    }

    @Override
    protected LogoutResponse toResponse(CloseableHttpResponse response) throws IOException {
        return new LogoutResponse(response);
    }
}

