/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.tomcat;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.security.cert.X509Certificate;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.Request;
import org.keycloak.adapters.spi.AuthenticationError;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.LogoutError;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.ServerCookie;
import org.keycloak.common.util.UriUtils;

public class CatalinaHttpFacade
implements HttpFacade {
    protected Request request;
    protected HttpServletResponse response;
    protected RequestFacade requestFacade = new RequestFacade();
    protected ResponseFacade responseFacade = new ResponseFacade();
    protected MultivaluedHashMap<String, String> queryParameters;

    public CatalinaHttpFacade(HttpServletResponse response, Request request) {
        this.response = response;
        this.request = request;
    }

    public HttpFacade.Request getRequest() {
        return this.requestFacade;
    }

    public HttpFacade.Response getResponse() {
        return this.responseFacade;
    }

    public X509Certificate[] getCertificateChain() {
        throw new IllegalStateException("Not supported yet");
    }

    public boolean isEnded() {
        return this.responseFacade.isEnded();
    }

    protected class ResponseFacade
    implements HttpFacade.Response {
        protected boolean ended;

        protected ResponseFacade() {
        }

        public void setStatus(int status) {
            CatalinaHttpFacade.this.response.setStatus(status);
        }

        public void addHeader(String name, String value) {
            CatalinaHttpFacade.this.response.addHeader(name, value);
        }

        public void setHeader(String name, String value) {
            CatalinaHttpFacade.this.response.setHeader(name, value);
        }

        public void resetCookie(String name, String path) {
            this.setCookie(name, "", path, null, 0, false, false);
        }

        public void setCookie(String name, String value, String path, String domain, int maxAge, boolean secure, boolean httpOnly) {
            StringBuffer cookieBuf = new StringBuffer();
            ServerCookie.appendCookieValue((StringBuffer)cookieBuf, (int)1, (String)name, (String)value, (String)path, (String)domain, null, (int)maxAge, (boolean)secure, (boolean)httpOnly);
            String cookie = cookieBuf.toString();
            CatalinaHttpFacade.this.response.addHeader("Set-Cookie", cookie);
        }

        public OutputStream getOutputStream() {
            try {
                return CatalinaHttpFacade.this.response.getOutputStream();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void sendError(int code) {
            try {
                CatalinaHttpFacade.this.response.sendError(code);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void sendError(int code, String message) {
            try {
                CatalinaHttpFacade.this.response.sendError(code, message);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void end() {
            this.ended = true;
        }

        public boolean isEnded() {
            return this.ended;
        }
    }

    protected class RequestFacade
    implements HttpFacade.Request {
        protected RequestFacade() {
        }

        public String getURI() {
            StringBuffer buf = CatalinaHttpFacade.this.request.getRequestURL();
            if (CatalinaHttpFacade.this.request.getQueryString() != null) {
                buf.append('?').append(CatalinaHttpFacade.this.request.getQueryString());
            }
            return buf.toString();
        }

        public String getRelativePath() {
            String contextPath;
            String uri = CatalinaHttpFacade.this.request.getRequestURI();
            String servletPath = uri.substring(uri.indexOf(contextPath = CatalinaHttpFacade.this.request.getContextPath()) + contextPath.length());
            if ("".equals(servletPath)) {
                servletPath = "/";
            }
            return servletPath;
        }

        public boolean isSecure() {
            return CatalinaHttpFacade.this.request.isSecure();
        }

        public String getFirstParam(String param) {
            return CatalinaHttpFacade.this.request.getParameter(param);
        }

        public String getQueryParamValue(String paramName) {
            if (CatalinaHttpFacade.this.queryParameters == null) {
                CatalinaHttpFacade.this.queryParameters = UriUtils.decodeQueryString((String)CatalinaHttpFacade.this.request.getQueryString());
            }
            return (String)CatalinaHttpFacade.this.queryParameters.getFirst((Object)paramName);
        }

        public HttpFacade.Cookie getCookie(String cookieName) {
            if (CatalinaHttpFacade.this.request.getCookies() == null) {
                return null;
            }
            Cookie cookie = null;
            for (Cookie c : CatalinaHttpFacade.this.request.getCookies()) {
                if (!c.getName().equals(cookieName)) continue;
                cookie = c;
                break;
            }
            if (cookie == null) {
                return null;
            }
            return new HttpFacade.Cookie(cookie.getName(), cookie.getValue(), cookie.getVersion(), cookie.getDomain(), cookie.getPath());
        }

        public List<String> getHeaders(String name) {
            Enumeration headers = CatalinaHttpFacade.this.request.getHeaders(name);
            if (headers == null) {
                return null;
            }
            ArrayList<String> list = new ArrayList<String>();
            while (headers.hasMoreElements()) {
                list.add((String)headers.nextElement());
            }
            return list;
        }

        public InputStream getInputStream() {
            try {
                return CatalinaHttpFacade.this.request.getInputStream();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String getMethod() {
            return CatalinaHttpFacade.this.request.getMethod();
        }

        public String getHeader(String name) {
            return CatalinaHttpFacade.this.request.getHeader(name);
        }

        public String getRemoteAddr() {
            return CatalinaHttpFacade.this.request.getRemoteAddr();
        }

        public void setError(AuthenticationError error) {
            CatalinaHttpFacade.this.request.setAttribute(AuthenticationError.class.getName(), (Object)error);
        }

        public void setError(LogoutError error) {
            CatalinaHttpFacade.this.request.setAttribute(LogoutError.class.getName(), (Object)error);
        }
    }
}

