/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.timer.basic;

import java.util.Timer;
import java.util.TimerTask;
import org.jboss.logging.Logger;
import org.keycloak.timer.TimerProvider;
import org.keycloak.timer.basic.BasicTimerProviderFactory;

public class BasicTimerProvider
implements TimerProvider {
    private static final Logger logger = Logger.getLogger(BasicTimerProvider.class);
    private final Timer timer;
    private final BasicTimerProviderFactory factory;

    public BasicTimerProvider(Timer timer, BasicTimerProviderFactory factory) {
        this.timer = timer;
        this.factory = factory;
    }

    public void schedule(final Runnable runnable, long interval, String taskName) {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                runnable.run();
            }
        };
        TimerTask existingTask = this.factory.putTask(taskName, task);
        if (existingTask != null) {
            logger.debugf("Existing timer task '%s' found. Cancelling it", (Object)taskName);
            existingTask.cancel();
        }
        logger.debugf("Starting task '%s' with interval '%d'", (Object)taskName, (Object)interval);
        this.timer.schedule(task, interval, interval);
    }

    public void cancelTask(String taskName) {
        TimerTask existingTask = this.factory.removeTask(taskName);
        if (existingTask != null) {
            logger.debugf("Cancelling task '%s'", (Object)taskName);
            existingTask.cancel();
        }
    }

    public void close() {
    }
}

