/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.test.framework.oauth;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;

class OAuthCallbackServer {
    private final HttpServer httpServer;
    private final OAuthCallbackHandler callbackHandler = new OAuthCallbackHandler();
    private final URI redirectionUri;

    public OAuthCallbackServer() {
        try {
            this.httpServer = HttpServer.create(new InetSocketAddress("127.0.0.1", 0), 0);
            this.httpServer.createContext("/callback/oauth", this.callbackHandler);
            this.httpServer.start();
            this.redirectionUri = new URI("http://127.0.0.1:" + this.httpServer.getAddress().getPort() + "/callback/oauth");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public URI getRedirectionUri() {
        return this.redirectionUri;
    }

    public List<URI> getCallbacks() {
        return this.callbackHandler.callbacks;
    }

    public void close() {
        this.httpServer.stop(0);
    }

    static class OAuthCallbackHandler
    implements HttpHandler {
        private List<URI> callbacks = new LinkedList<URI>();

        OAuthCallbackHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            this.callbacks.add(exchange.getRequestURI());
            byte[] happydays = new String("<html><body>Happy days</body></html>").getBytes(StandardCharsets.UTF_8);
            exchange.getResponseHeaders().set("Content-Type", "text/html");
            exchange.sendResponseHeaders(200, happydays.length);
            exchange.getResponseBody().write(happydays);
            exchange.getResponseBody().close();
        }
    }
}

