/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.test.framework.database;

import java.util.HashMap;
import java.util.Map;

public class DatabaseConfig {
    private String vendor;
    private String containerImage;
    private String url;
    private String username;
    private String password;
    private String postStartCommand;
    private Map<String, String> env = new HashMap<String, String>();

    public String getVendor() {
        return this.vendor;
    }

    public DatabaseConfig vendor(String vendor) {
        this.vendor = vendor;
        return this;
    }

    public String getContainerImage() {
        return this.containerImage;
    }

    public DatabaseConfig containerImage(String containerImage) {
        this.containerImage = containerImage;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public DatabaseConfig url(String url) {
        this.url = url;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public DatabaseConfig username(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public DatabaseConfig password(String password) {
        this.password = password;
        return this;
    }

    public String getPostStartCommand() {
        return this.postStartCommand;
    }

    public DatabaseConfig postStartCommand(String postStartCommand) {
        this.postStartCommand = postStartCommand;
        return this;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public DatabaseConfig env(Map<String, String> env) {
        this.env = env;
        return this;
    }

    public Map<String, String> toConfig() {
        HashMap<String, String> config = new HashMap<String, String>();
        if (this.vendor != null) {
            config.put("db", this.vendor);
        }
        if (this.url != null) {
            config.put("db-url", this.url);
        }
        if (this.username != null) {
            config.put("db-username", this.username);
        }
        if (this.password != null) {
            config.put("db-password", this.password);
        }
        return config;
    }
}

