/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.mem;

import java.util.concurrent.ConcurrentHashMap;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.UserSessionProviderFactory;
import org.keycloak.models.sessions.mem.MemUserSessionProvider;
import org.keycloak.models.sessions.mem.entities.ClientSessionEntity;
import org.keycloak.models.sessions.mem.entities.UserSessionEntity;
import org.keycloak.models.sessions.mem.entities.UsernameLoginFailureEntity;
import org.keycloak.models.sessions.mem.entities.UsernameLoginFailureKey;

public class MemUserSessionProviderFactory
implements UserSessionProviderFactory {
    public static final String ID = "mem";
    private ConcurrentHashMap<String, UserSessionEntity> userSessions = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ClientSessionEntity> clientSessions = new ConcurrentHashMap();
    private ConcurrentHashMap<UsernameLoginFailureKey, UsernameLoginFailureEntity> loginFailures = new ConcurrentHashMap();

    public UserSessionProvider create(KeycloakSession session) {
        return new MemUserSessionProvider(session, this.userSessions, this.clientSessions, this.loginFailures);
    }

    public void init(Config.Scope config) {
    }

    public void close() {
        this.userSessions.clear();
        this.loginFailures.clear();
    }

    public String getId() {
        return ID;
    }
}

