/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;

public interface ClientModel
extends RoleContainerModel {
    public static final String PRIVATE_KEY = "privateKey";
    public static final String PUBLIC_KEY = "publicKey";
    public static final String X509CERTIFICATE = "X509Certificate";

    public void updateClient();

    public String getId();

    public String getClientId();

    public void setClientId(String var1);

    public String getName();

    public void setName(String var1);

    public boolean isEnabled();

    public void setEnabled(boolean var1);

    public boolean isSurrogateAuthRequired();

    public void setSurrogateAuthRequired(boolean var1);

    public Set<String> getWebOrigins();

    public void setWebOrigins(Set<String> var1);

    public void addWebOrigin(String var1);

    public void removeWebOrigin(String var1);

    public Set<String> getRedirectUris();

    public void setRedirectUris(Set<String> var1);

    public void addRedirectUri(String var1);

    public void removeRedirectUri(String var1);

    public String getManagementUrl();

    public void setManagementUrl(String var1);

    public String getBaseUrl();

    public void setBaseUrl(String var1);

    public List<String> getDefaultRoles();

    public void addDefaultRole(String var1);

    public void updateDefaultRoles(String[] var1);

    public Set<RoleModel> getClientScopeMappings(ClientModel var1);

    public boolean isBearerOnly();

    public void setBearerOnly(boolean var1);

    public int getNodeReRegistrationTimeout();

    public void setNodeReRegistrationTimeout(int var1);

    public String getClientAuthenticatorType();

    public void setClientAuthenticatorType(String var1);

    public boolean validateSecret(String var1);

    public String getSecret();

    public void setSecret(String var1);

    public boolean isFullScopeAllowed();

    public void setFullScopeAllowed(boolean var1);

    public String getProtocol();

    public void setProtocol(String var1);

    public void setAttribute(String var1, String var2);

    public void removeAttribute(String var1);

    public String getAttribute(String var1);

    public Map<String, String> getAttributes();

    public boolean isFrontchannelLogout();

    public void setFrontchannelLogout(boolean var1);

    public boolean isPublicClient();

    public void setPublicClient(boolean var1);

    public boolean isDirectGrantsOnly();

    public void setDirectGrantsOnly(boolean var1);

    public boolean isConsentRequired();

    public void setConsentRequired(boolean var1);

    public boolean isServiceAccountsEnabled();

    public void setServiceAccountsEnabled(boolean var1);

    public Set<RoleModel> getScopeMappings();

    public void addScopeMapping(RoleModel var1);

    public void deleteScopeMapping(RoleModel var1);

    public Set<RoleModel> getRealmScopeMappings();

    public boolean hasScope(RoleModel var1);

    public RealmModel getRealm();

    public int getNotBefore();

    public void setNotBefore(int var1);

    public Set<ProtocolMapperModel> getProtocolMappers();

    public ProtocolMapperModel addProtocolMapper(ProtocolMapperModel var1);

    public void removeProtocolMapper(ProtocolMapperModel var1);

    public void updateProtocolMapper(ProtocolMapperModel var1);

    public ProtocolMapperModel getProtocolMapperById(String var1);

    public ProtocolMapperModel getProtocolMapperByName(String var1, String var2);

    public Map<String, Integer> getRegisteredNodes();

    public void registerNode(String var1, int var2);

    public void unregisterNode(String var1);
}

