/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.entities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.enums.SslRequired;
import org.keycloak.models.ClientModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.cache.RealmCache;
import org.keycloak.models.cache.entities.CachedClient;
import org.keycloak.models.cache.entities.CachedRealmRole;
import org.keycloak.util.MultivaluedHashMap;

public class CachedRealm {
    private String id;
    private String name;
    private boolean enabled;
    private SslRequired sslRequired;
    private boolean registrationAllowed;
    private boolean registrationEmailAsUsername;
    private boolean rememberMe;
    private boolean verifyEmail;
    private boolean passwordCredentialGrantAllowed;
    private boolean resetPasswordAllowed;
    private boolean identityFederationEnabled;
    private boolean bruteForceProtected;
    private int maxFailureWaitSeconds;
    private int minimumQuickLoginWaitSeconds;
    private int waitIncrementSeconds;
    private long quickLoginCheckMilliSeconds;
    private int maxDeltaTimeSeconds;
    private int failureFactor;
    private int ssoSessionIdleTimeout;
    private int ssoSessionMaxLifespan;
    private int accessTokenLifespan;
    private int accessCodeLifespan;
    private int accessCodeLifespanUserAction;
    private int accessCodeLifespanLogin;
    private int notBefore;
    private PasswordPolicy passwordPolicy;
    private String publicKeyPem;
    private String privateKeyPem;
    private String certificatePem;
    private String codeSecret;
    private String loginTheme;
    private String accountTheme;
    private String adminTheme;
    private String emailTheme;
    private String masterAdminClient;
    private List<RequiredCredentialModel> requiredCredentials = new ArrayList<RequiredCredentialModel>();
    private List<UserFederationProviderModel> userFederationProviders = new ArrayList<UserFederationProviderModel>();
    private List<IdentityProviderModel> identityProviders = new ArrayList<IdentityProviderModel>();
    private Map<String, String> browserSecurityHeaders = new HashMap<String, String>();
    private Map<String, String> smtpConfig = new HashMap<String, String>();
    private boolean eventsEnabled;
    private long eventsExpiration;
    private Set<String> eventsListeners = new HashSet<String>();
    private Set<String> enabledEventTypes = new HashSet<String>();
    private List<String> defaultRoles = new LinkedList<String>();
    private Map<String, String> realmRoles = new HashMap<String, String>();
    private Map<String, String> clients = new HashMap<String, String>();
    private boolean internationalizationEnabled;
    private Set<String> supportedLocales = new HashSet<String>();
    private String defaultLocale;
    private MultivaluedHashMap<String, IdentityProviderMapperModel> identityProviderMappers = new MultivaluedHashMap();

    public CachedRealm() {
    }

    public CachedRealm(RealmCache cache, RealmProvider delegate, RealmModel model) {
        this.id = model.getId();
        this.name = model.getName();
        this.enabled = model.isEnabled();
        this.sslRequired = model.getSslRequired();
        this.registrationAllowed = model.isRegistrationAllowed();
        this.registrationEmailAsUsername = model.isRegistrationEmailAsUsername();
        this.rememberMe = model.isRememberMe();
        this.verifyEmail = model.isVerifyEmail();
        this.passwordCredentialGrantAllowed = model.isPasswordCredentialGrantAllowed();
        this.resetPasswordAllowed = model.isResetPasswordAllowed();
        this.identityFederationEnabled = model.isIdentityFederationEnabled();
        this.bruteForceProtected = model.isBruteForceProtected();
        this.maxFailureWaitSeconds = model.getMaxFailureWaitSeconds();
        this.minimumQuickLoginWaitSeconds = model.getMinimumQuickLoginWaitSeconds();
        this.waitIncrementSeconds = model.getWaitIncrementSeconds();
        this.quickLoginCheckMilliSeconds = model.getQuickLoginCheckMilliSeconds();
        this.maxDeltaTimeSeconds = model.getMaxDeltaTimeSeconds();
        this.failureFactor = model.getFailureFactor();
        this.ssoSessionIdleTimeout = model.getSsoSessionIdleTimeout();
        this.ssoSessionMaxLifespan = model.getSsoSessionMaxLifespan();
        this.accessTokenLifespan = model.getAccessTokenLifespan();
        this.accessCodeLifespan = model.getAccessCodeLifespan();
        this.accessCodeLifespanUserAction = model.getAccessCodeLifespanUserAction();
        this.accessCodeLifespanLogin = model.getAccessCodeLifespanLogin();
        this.notBefore = model.getNotBefore();
        this.passwordPolicy = model.getPasswordPolicy();
        this.publicKeyPem = model.getPublicKeyPem();
        this.privateKeyPem = model.getPrivateKeyPem();
        this.certificatePem = model.getCertificatePem();
        this.codeSecret = model.getCodeSecret();
        this.loginTheme = model.getLoginTheme();
        this.accountTheme = model.getAccountTheme();
        this.adminTheme = model.getAdminTheme();
        this.emailTheme = model.getEmailTheme();
        this.requiredCredentials = model.getRequiredCredentials();
        this.userFederationProviders = model.getUserFederationProviders();
        this.identityProviders = new ArrayList<IdentityProviderModel>();
        for (IdentityProviderModel identityProviderModel : model.getIdentityProviders()) {
            this.identityProviders.add(new IdentityProviderModel(identityProviderModel));
        }
        for (IdentityProviderMapperModel mapper : model.getIdentityProviderMappers()) {
            this.identityProviderMappers.add((Object)mapper.getIdentityProviderAlias(), (Object)mapper);
        }
        this.smtpConfig.putAll(model.getSmtpConfig());
        this.browserSecurityHeaders.putAll(model.getBrowserSecurityHeaders());
        this.eventsEnabled = model.isEventsEnabled();
        this.eventsExpiration = model.getEventsExpiration();
        this.eventsListeners.addAll(model.getEventsListeners());
        this.enabledEventTypes.addAll(model.getEnabledEventTypes());
        this.defaultRoles.addAll(model.getDefaultRoles());
        this.masterAdminClient = model.getMasterAdminClient().getId();
        for (RoleModel role : model.getRoles()) {
            this.realmRoles.put(role.getName(), role.getId());
            CachedRealmRole cachedRole = new CachedRealmRole(role, model);
            cache.addCachedRole(cachedRole);
        }
        for (ClientModel client : model.getClients()) {
            this.clients.put(client.getClientId(), client.getId());
            CachedClient cachedClient = new CachedClient(cache, delegate, model, client);
            cache.addCachedClient(cachedClient);
        }
        this.internationalizationEnabled = model.isInternationalizationEnabled();
        this.supportedLocales.addAll(model.getSupportedLocales());
        this.defaultLocale = model.getDefaultLocale();
    }

    public String getId() {
        return this.id;
    }

    public String getMasterAdminClient() {
        return this.masterAdminClient;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getDefaultRoles() {
        return this.defaultRoles;
    }

    public Map<String, String> getRealmRoles() {
        return this.realmRoles;
    }

    public Map<String, String> getClients() {
        return this.clients;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public SslRequired getSslRequired() {
        return this.sslRequired;
    }

    public boolean isRegistrationAllowed() {
        return this.registrationAllowed;
    }

    public boolean isRegistrationEmailAsUsername() {
        return this.registrationEmailAsUsername;
    }

    public boolean isPasswordCredentialGrantAllowed() {
        return this.passwordCredentialGrantAllowed;
    }

    public boolean isRememberMe() {
        return this.rememberMe;
    }

    public boolean isBruteForceProtected() {
        return this.bruteForceProtected;
    }

    public int getMaxFailureWaitSeconds() {
        return this.maxFailureWaitSeconds;
    }

    public int getWaitIncrementSeconds() {
        return this.waitIncrementSeconds;
    }

    public int getMinimumQuickLoginWaitSeconds() {
        return this.minimumQuickLoginWaitSeconds;
    }

    public long getQuickLoginCheckMilliSeconds() {
        return this.quickLoginCheckMilliSeconds;
    }

    public int getMaxDeltaTimeSeconds() {
        return this.maxDeltaTimeSeconds;
    }

    public int getFailureFactor() {
        return this.failureFactor;
    }

    public boolean isVerifyEmail() {
        return this.verifyEmail;
    }

    public boolean isResetPasswordAllowed() {
        return this.resetPasswordAllowed;
    }

    public int getSsoSessionIdleTimeout() {
        return this.ssoSessionIdleTimeout;
    }

    public int getSsoSessionMaxLifespan() {
        return this.ssoSessionMaxLifespan;
    }

    public int getAccessTokenLifespan() {
        return this.accessTokenLifespan;
    }

    public int getAccessCodeLifespan() {
        return this.accessCodeLifespan;
    }

    public int getAccessCodeLifespanUserAction() {
        return this.accessCodeLifespanUserAction;
    }

    public int getAccessCodeLifespanLogin() {
        return this.accessCodeLifespanLogin;
    }

    public String getPublicKeyPem() {
        return this.publicKeyPem;
    }

    public String getPrivateKeyPem() {
        return this.privateKeyPem;
    }

    public String getCodeSecret() {
        return this.codeSecret;
    }

    public List<RequiredCredentialModel> getRequiredCredentials() {
        return this.requiredCredentials;
    }

    public PasswordPolicy getPasswordPolicy() {
        return this.passwordPolicy;
    }

    public boolean isIdentityFederationEnabled() {
        return this.identityFederationEnabled;
    }

    public Map<String, String> getSmtpConfig() {
        return this.smtpConfig;
    }

    public Map<String, String> getBrowserSecurityHeaders() {
        return this.browserSecurityHeaders;
    }

    public String getLoginTheme() {
        return this.loginTheme;
    }

    public String getAccountTheme() {
        return this.accountTheme;
    }

    public String getAdminTheme() {
        return this.adminTheme;
    }

    public String getEmailTheme() {
        return this.emailTheme;
    }

    public int getNotBefore() {
        return this.notBefore;
    }

    public boolean isEventsEnabled() {
        return this.eventsEnabled;
    }

    public long getEventsExpiration() {
        return this.eventsExpiration;
    }

    public Set<String> getEventsListeners() {
        return this.eventsListeners;
    }

    public Set<String> getEnabledEventTypes() {
        return this.enabledEventTypes;
    }

    public List<UserFederationProviderModel> getUserFederationProviders() {
        return this.userFederationProviders;
    }

    public String getCertificatePem() {
        return this.certificatePem;
    }

    public List<IdentityProviderModel> getIdentityProviders() {
        return this.identityProviders;
    }

    public boolean isInternationalizationEnabled() {
        return this.internationalizationEnabled;
    }

    public Set<String> getSupportedLocales() {
        return this.supportedLocales;
    }

    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    public MultivaluedHashMap<String, IdentityProviderMapperModel> getIdentityProviderMappers() {
        return this.identityProviderMappers;
    }
}

