/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.terminal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.jboss.aesh.util.LoggerUtil;

public class InfocmpHandler {
    private Map<String, String> values;
    private static final String ESCAPE = "\\E";
    private static final String ESC_AS_STRING = "\u001b";
    private static final Logger LOGGER = LoggerUtil.getLogger(InfocmpHandler.class.getName());

    public static InfocmpHandler getInstance() {
        return InfocmpHolder.INSTANCE;
    }

    private InfocmpHandler() {
        if (this.values == null) {
            this.parseInfocmp();
        }
    }

    private void parseInfocmp() {
        this.values = new HashMap<String, String>();
        this.fetchInfocmp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchInfocmp() {
        InputStream in = null;
        ByteArrayOutputStream out = null;
        try {
            int c;
            ProcessBuilder builder = new ProcessBuilder("infocmp");
            builder.redirectErrorStream(true);
            Process process = builder.start();
            in = process.getInputStream();
            out = new ByteArrayOutputStream();
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            for (String keyValue : new String(out.toByteArray()).split(",")) {
                String[] valuePair = keyValue.split("=");
                if (valuePair.length != 2) continue;
                this.values.put(valuePair[0].trim(), valuePair[1]);
            }
            process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            LOGGER.warning("Failed to execute infocmp, using default values: " + e.getMessage());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                LOGGER.warning("Failed to close streams: " + e.getMessage());
            }
        }
    }

    public int[] getAsInts(String key) {
        if (this.values.containsKey(key)) {
            return this.convertStringToInts(this.values.get(key));
        }
        return new int[0];
    }

    private int[] convertStringToInts(String input) {
        if (input.startsWith(ESCAPE)) {
            int[] out = new int[input.length() - 1];
            out[0] = 27;
            int counter = 1;
            char[] cArray = input.substring(2).toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                int c;
                out[counter] = c = cArray[i];
                ++counter;
            }
            return out;
        }
        int[] out = new int[input.length()];
        int counter = 0;
        char[] cArray = input.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            int c;
            out[counter] = c = cArray[i];
            ++counter;
        }
        return out;
    }

    public String get(String key) {
        if (this.values.containsKey(key)) {
            return this.values.get(key).replaceAll("\\\\E", ESC_AS_STRING);
        }
        return "";
    }

    private static class InfocmpHolder {
        static final InfocmpHandler INSTANCE = new InfocmpHandler();

        private InfocmpHolder() {
        }
    }
}

