/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.idm.authorization;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;

public class UmaPermissionRepresentation
extends AbstractPolicyRepresentation {
    private String id;
    private String description;
    private Set<String> roles;
    private Set<String> groups;
    private Set<String> clients;
    private String condition;

    @Override
    public String getType() {
        return "uma";
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public void addRole(String ... role) {
        if (this.roles == null) {
            this.roles = new HashSet<String>();
        }
        this.roles.addAll(Arrays.asList(role));
    }

    public void addClientRole(String clientId, String roleName) {
        this.addRole(clientId + "/" + roleName);
    }

    public void removeRole(String role) {
        if (this.roles != null) {
            this.roles.remove(role);
        }
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public void addGroup(String ... group) {
        if (this.groups == null) {
            this.groups = new HashSet<String>();
        }
        this.groups.addAll(Arrays.asList(group));
    }

    public void removeGroup(String group) {
        if (this.groups != null) {
            this.groups.remove(group);
        }
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public void setClients(Set<String> clients) {
        this.clients = clients;
    }

    public void addClient(String ... client) {
        if (this.clients == null) {
            this.clients = new HashSet<String>();
        }
        this.clients.addAll(Arrays.asList(client));
    }

    public void removeClient(String client) {
        if (this.clients != null) {
            this.clients.remove(client);
        }
    }

    public Set<String> getClients() {
        return this.clients;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getCondition() {
        return this.condition;
    }
}

