/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console.export;

import org.jboss.aesh.complete.CompleteOperation;
import org.jboss.aesh.complete.Completion;
import org.jboss.aesh.console.export.ExportManager;
import org.jboss.aesh.parser.Parser;

public class ExportCompletion
implements Completion {
    private static final String EXPORT = "export";
    private static final String EXPORT_SPACE = "export ";
    private final ExportManager exportManager;

    public ExportCompletion(ExportManager manager) {
        this.exportManager = manager;
    }

    @Override
    public void complete(CompleteOperation completeOperation) {
        String word;
        if (completeOperation.getBuffer() == null || completeOperation.getBuffer().length() < 1) {
            completeOperation.addCompletionCandidate(EXPORT);
        } else if (EXPORT.startsWith(completeOperation.getBuffer())) {
            completeOperation.addCompletionCandidate(EXPORT);
        } else if (EXPORT_SPACE.equals(completeOperation.getBuffer()) || EXPORT.equals(completeOperation.getBuffer().trim())) {
            completeOperation.addCompletionCandidates(this.exportManager.getAllNamesWithEquals());
            completeOperation.setOffset(completeOperation.getCursor());
        } else if (completeOperation.getBuffer().startsWith(EXPORT_SPACE)) {
            String word2 = Parser.findCurrentWordFromCursor(completeOperation.getBuffer(), completeOperation.getCursor());
            if (word2.length() > 0) {
                completeOperation.addCompletionCandidates(this.exportManager.findAllMatchingKeys(word2));
                if (Parser.containsNonEscapedDollar(word2)) {
                    int index = word2.lastIndexOf(36);
                    completeOperation.setOffset(completeOperation.getCursor() - (word2.length() - index));
                } else {
                    completeOperation.setOffset(completeOperation.getCursor() - word2.length());
                }
            }
        } else if (Parser.containsNonEscapedDollar(completeOperation.getBuffer()) && Parser.containsNonEscapedDollar(word = Parser.findCurrentWordFromCursor(completeOperation.getBuffer(), completeOperation.getCursor()))) {
            completeOperation.addCompletionCandidates(this.exportManager.findAllMatchingKeys(word));
            completeOperation.setOffset(completeOperation.getCursor() - word.length());
        }
    }
}

