/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console;

import java.io.IOException;
import java.util.logging.Logger;
import org.jboss.aesh.console.Buffer;
import org.jboss.aesh.console.CompletionHandler;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.ConsoleBuffer;
import org.jboss.aesh.console.InputProcessor;
import org.jboss.aesh.console.InputProcessorInterruptHook;
import org.jboss.aesh.console.command.CommandOperation;
import org.jboss.aesh.console.helper.Search;
import org.jboss.aesh.edit.EmacsEditMode;
import org.jboss.aesh.edit.KeyOperationFactory;
import org.jboss.aesh.edit.KeyOperationManager;
import org.jboss.aesh.edit.Mode;
import org.jboss.aesh.edit.ViEditMode;
import org.jboss.aesh.edit.actions.Action;
import org.jboss.aesh.edit.actions.EditActionManager;
import org.jboss.aesh.edit.actions.Movement;
import org.jboss.aesh.edit.actions.Operation;
import org.jboss.aesh.history.History;
import org.jboss.aesh.history.SearchDirection;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.terminal.Key;
import org.jboss.aesh.undo.UndoAction;
import org.jboss.aesh.util.LoggerUtil;

public class AeshInputProcessor
implements InputProcessor {
    private final InputProcessorInterruptHook interruptHook;
    private Search search;
    private final History history;
    private final ConsoleBuffer consoleBuffer;
    private final CompletionHandler completionHandler;
    private Action prevAction = Action.EDIT;
    private boolean searchDisabled = false;
    private static final String ENDS_WITH_BACKSLASH = " \\";
    private static final Logger LOGGER = LoggerUtil.getLogger(AeshInputProcessor.class.getName());

    AeshInputProcessor(ConsoleBuffer consoleBuffer, History history, CompletionHandler completionHandler, InputProcessorInterruptHook interruptHook, boolean historyEnabled, boolean searchEnabled) {
        this.consoleBuffer = consoleBuffer;
        this.history = history;
        if (historyEnabled) {
            history.enable();
        } else {
            history.disable();
        }
        this.completionHandler = completionHandler;
        this.interruptHook = interruptHook;
        boolean bl = this.searchDisabled = !searchEnabled;
        if (!history.isEnabled()) {
            this.searchDisabled = true;
        }
    }

    @Override
    public void resetBuffer() {
        this.consoleBuffer.getBuffer().reset();
        this.search = null;
    }

    @Override
    public String parseOperation(CommandOperation commandOperation) throws IOException {
        Operation operation = this.consoleBuffer.getEditMode().parseInput(commandOperation.getInputKey(), this.consoleBuffer.getBuffer().getLine());
        if (commandOperation.getInputKey() != Key.UNKNOWN) {
            operation.setInput(commandOperation.getInputKey().getKeyValues());
        } else {
            operation.setInput(new int[]{commandOperation.getInput()[commandOperation.getPosition()]});
        }
        Action action = operation.getAction();
        if (action == Action.EDIT) {
            if (Key.isPrintable(operation.getInput())) {
                this.consoleBuffer.writeChars(operation.getInput());
            }
        } else if (this.consoleBuffer.getBuffer().isMasking()) {
            if (action == Action.DELETE) {
                if (this.consoleBuffer.getBuffer().getPrompt().getMask().charValue() == '\u0000') {
                    this.deleteWithMaskEnabled();
                } else {
                    this.consoleBuffer.performAction(EditActionManager.parseAction(operation, this.consoleBuffer.getBuffer().getCursor(), this.consoleBuffer.getBuffer().length(), this.consoleBuffer.getEditMode().getMode()));
                }
            } else if (action == Action.INTERRUPT && this.interruptHook != null) {
                this.consoleBuffer.out().print(Config.getLineSeparator());
                this.interruptHook.handleInterrupt(action);
            }
        } else if (action == Action.SEARCH && !this.searchDisabled) {
            if (this.search == null) {
                this.search = new Search(operation, operation.getInput()[0]);
            } else {
                this.search.setOperation(operation);
                this.search.setInput(operation.getInput()[0]);
            }
            this.doSearch(this.search);
            if (this.search.isFinished()) {
                return this.search.getResult();
            }
        } else if (action == Action.MOVE || action == Action.DELETE || action == Action.CHANGE || action == Action.YANK) {
            this.consoleBuffer.performAction(EditActionManager.parseAction(operation, this.consoleBuffer.getBuffer().getCursor(), this.consoleBuffer.getBuffer().length(), this.consoleBuffer.getEditMode().getMode()));
        } else if (action != Action.ABORT) {
            if (action == Action.CASE) {
                if (operation.getMovement() == Movement.BEGINNING) {
                    this.consoleBuffer.capitalizeWord();
                } else if (operation.getMovement() == Movement.NEXT) {
                    this.consoleBuffer.upperCaseWord();
                } else if (operation.getMovement() == Movement.PREV) {
                    this.consoleBuffer.lowerCaseWord();
                } else {
                    this.consoleBuffer.addActionToUndoStack();
                    this.consoleBuffer.changeCase();
                }
            } else if (action == Action.COMPLETE) {
                if (operation.getMovement() == Movement.NEXT) {
                    this.complete();
                } else if (this.completionHandler != null) {
                    this.completionHandler.setAskDisplayCompletion(false);
                    this.consoleBuffer.getUndoManager().clear();
                    this.consoleBuffer.out().print(Config.getLineSeparator());
                    this.consoleBuffer.displayPrompt();
                    this.consoleBuffer.out().print(this.consoleBuffer.getBuffer().getLine());
                    this.prevAction = Action.NEWLINE;
                }
            } else if (action == Action.EXIT || action == Action.EOF || action == Action.INTERRUPT || action == Action.IGNOREEOF) {
                if (this.interruptHook != null) {
                    this.consoleBuffer.out().print(Config.getLineSeparator());
                    this.interruptHook.handleInterrupt(action);
                }
            } else if (action == Action.HISTORY && this.history.isEnabled()) {
                if (operation.getMovement() == Movement.NEXT) {
                    this.getHistoryElement(true);
                } else if (operation.getMovement() == Movement.PREV) {
                    this.getHistoryElement(false);
                }
            } else if (action == Action.UNDO) {
                this.undo();
            } else if (action == Action.PASTE_FROM_CLIPBOARD) {
                this.consoleBuffer.addActionToUndoStack();
            } else if (action == Action.PASTE) {
                if (operation.getMovement() == Movement.NEXT) {
                    this.consoleBuffer.paste(0, true);
                } else {
                    this.consoleBuffer.paste(0, false);
                }
            } else if (action == Action.CHANGE_EDITMODE) {
                this.changeEditMode(operation.getMovement());
            } else if (action == Action.CLEAR) {
                this.consoleBuffer.clear(true);
            } else if (action == Action.REPLACE) {
                this.consoleBuffer.replace(operation.getInput()[0]);
            } else if (action == Action.NO_ACTION) {
                // empty if block
            }
        }
        if (action == Action.HISTORY && this.history.isEnabled()) {
            this.prevAction = action;
        }
        if (action == Action.NEWLINE) {
            this.consoleBuffer.getUndoManager().clear();
            boolean isCurrentLineEnding = true;
            if (!this.consoleBuffer.getBuffer().isMasking()) {
                if (this.consoleBuffer.getBuffer().getLine().endsWith(ENDS_WITH_BACKSLASH)) {
                    this.consoleBuffer.getBuffer().setMultiLine(true);
                    this.consoleBuffer.getBuffer().updateMultiLineBuffer();
                    isCurrentLineEnding = false;
                } else if (Parser.doesStringContainOpenQuote(this.consoleBuffer.getBuffer().getMultiLine())) {
                    this.consoleBuffer.getBuffer().setMultiLine(true);
                    this.consoleBuffer.getBuffer().updateMultiLineBuffer();
                    isCurrentLineEnding = false;
                } else if (this.history.isEnabled()) {
                    if (this.consoleBuffer.getBuffer().isMultiLine()) {
                        this.addToHistory(this.consoleBuffer.getBuffer().getMultiLineBuffer() + this.consoleBuffer.getBuffer().getLine());
                    } else {
                        this.addToHistory(this.consoleBuffer.getBuffer().getLine());
                    }
                }
            }
            this.prevAction = Action.NEWLINE;
            String result = this.consoleBuffer.getBuffer().isMultiLine() ? this.consoleBuffer.getBuffer().getMultiLineBuffer() + this.consoleBuffer.getBuffer().getLineNoMask() : this.consoleBuffer.getBuffer().getLineNoMask();
            if (this.consoleBuffer.getBuffer().isEchoing()) {
                this.consoleBuffer.moveCursor(this.consoleBuffer.getBuffer().totalLength());
                this.consoleBuffer.out().print(Config.getLineSeparator());
            }
            this.search = null;
            if (isCurrentLineEnding) {
                this.consoleBuffer.getBuffer().setMultiLine(false);
                this.consoleBuffer.getBuffer().reset();
                return result;
            }
            this.consoleBuffer.displayPrompt();
        }
        return null;
    }

    @Override
    public History getHistory() {
        return this.history;
    }

    @Override
    public CompletionHandler getCompleter() {
        return this.completionHandler;
    }

    @Override
    public void clearBufferAndDisplayPrompt() {
        this.consoleBuffer.getBuffer().reset();
        this.consoleBuffer.getUndoManager().clear();
        this.prevAction = Action.NEWLINE;
        this.consoleBuffer.displayPrompt();
    }

    private void doSearch(Search search) throws IOException {
        if (search.getOperation() == Operation.SEARCH_INTERRUPT) {
            this.consoleBuffer.moveCursor(-this.consoleBuffer.getBuffer().getCursor());
            this.consoleBuffer.setBufferLine("");
            this.consoleBuffer.drawLine();
            this.consoleBuffer.out().print(Buffer.printAnsi(this.consoleBuffer.getBuffer().getPrompt().getLength() + 1 + "G"));
            this.consoleBuffer.out().flush();
            return;
        }
        switch (search.getOperation().getMovement()) {
            case PREV: {
                this.history.setSearchDirection(SearchDirection.REVERSE);
                search.setSearchTerm(new StringBuilder(this.consoleBuffer.getBuffer().getLine()));
                if (search.getSearchTerm().length() <= 0) break;
                search.setResult(this.history.search(search.getSearchTerm().toString()));
                break;
            }
            case NEXT: {
                this.history.setSearchDirection(SearchDirection.FORWARD);
                search.setSearchTerm(new StringBuilder(this.consoleBuffer.getBuffer().getLine()));
                if (search.getSearchTerm().length() <= 0) break;
                search.setResult(this.history.search(search.getSearchTerm().toString()));
                break;
            }
            case PREV_WORD: {
                if (this.history.getSearchDirection() != SearchDirection.REVERSE) {
                    this.history.setSearchDirection(SearchDirection.REVERSE);
                }
                if (search.getSearchTerm().length() > 0) {
                    search.setResult(this.history.search(search.getSearchTerm().toString()));
                    break;
                }
                search.setResult(this.history.getPreviousFetch());
                break;
            }
            case NEXT_WORD: {
                if (this.history.getSearchDirection() != SearchDirection.FORWARD) {
                    this.history.setSearchDirection(SearchDirection.FORWARD);
                }
                if (search.getSearchTerm().length() <= 0) break;
                search.setResult(this.history.search(search.getSearchTerm().toString()));
                break;
            }
            case PREV_BIG_WORD: {
                if (search.getSearchTerm().length() <= 0) break;
                search.getSearchTerm().deleteCharAt(search.getSearchTerm().length() - 1);
                break;
            }
            case ALL: {
                search.getSearchTerm().appendCodePoint(search.getInput());
                String tmpResult = this.history.search(search.getSearchTerm().toString());
                if (tmpResult == null) {
                    search.getSearchTerm().deleteCharAt(search.getSearchTerm().length() - 1);
                    break;
                }
                search.setResult(tmpResult);
                break;
            }
            case END: {
                if (search.getResult() != null) {
                    this.consoleBuffer.moveCursor(-this.consoleBuffer.getBuffer().getCursor());
                    this.consoleBuffer.setBufferLine(search.getResult());
                    this.consoleBuffer.drawLine();
                    this.consoleBuffer.out().println();
                    this.history.push(this.consoleBuffer.getBuffer().getLineNoMask());
                    search.setResult(this.consoleBuffer.getBuffer().getLineNoMask());
                    search.setFinished(true);
                    this.consoleBuffer.getBuffer().reset();
                    return;
                }
                this.consoleBuffer.moveCursor(-this.consoleBuffer.getBuffer().getCursor());
                this.consoleBuffer.setBufferLine("");
                this.consoleBuffer.drawLine();
                break;
            }
            case NEXT_BIG_WORD: {
                if (search.getResult() != null) {
                    this.consoleBuffer.moveCursor(-this.consoleBuffer.getBuffer().getCursor());
                    this.consoleBuffer.setBufferLine(search.getResult());
                    search.setResult(null);
                    break;
                }
                this.consoleBuffer.moveCursor(-this.consoleBuffer.getBuffer().getCursor());
                this.consoleBuffer.setBufferLine("");
                break;
            }
        }
        if (this.consoleBuffer.getEditMode().getCurrentAction() == Action.SEARCH) {
            if (search.getSearchTerm().length() == 0) {
                if (search.getResult() != null) {
                    this.printSearch("", search.getResult());
                } else {
                    this.printSearch("", "");
                }
            } else if (search.getResult() != null) {
                this.printSearch(search.getSearchTerm().toString(), search.getResult());
            }
        } else {
            this.consoleBuffer.drawLine();
            this.consoleBuffer.out().print(Buffer.printAnsi(this.consoleBuffer.getBuffer().getPrompt().getLength() + 1 + "G"));
            this.consoleBuffer.out().flush();
        }
    }

    private void complete() {
        if (this.completionHandler != null) {
            try {
                this.completionHandler.complete(this.consoleBuffer.out(), this.consoleBuffer.getBuffer());
                if (this.completionHandler.doAskDisplayCompletion()) {
                    this.consoleBuffer.getEditMode().setAskForCompletions(true);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void changeEditMode(Movement movement) {
        if (this.consoleBuffer.getEditMode().getMode() == Mode.EMACS && movement == Movement.PREV) {
            this.consoleBuffer.setEditMode(new ViEditMode(new KeyOperationManager(KeyOperationFactory.generateViMode())));
        } else if (this.consoleBuffer.getEditMode().getMode() == Mode.VI && movement == Movement.NEXT) {
            this.consoleBuffer.setEditMode(new EmacsEditMode(new KeyOperationManager(KeyOperationFactory.generateEmacsMode())));
        }
    }

    private void getHistoryElement(boolean first) throws IOException {
        if (this.prevAction == Action.NEWLINE) {
            this.history.setCurrent(this.consoleBuffer.getBuffer().getLine());
        }
        String fromHistory = first ? this.history.getNextFetch() : this.history.getPreviousFetch();
        this.prevAction = Action.HISTORY;
        if (fromHistory != null) {
            this.consoleBuffer.setBufferLine(fromHistory);
            this.consoleBuffer.updateCurrentAction(Action.HISTORY);
            this.consoleBuffer.drawLine(false);
        }
    }

    private void addToHistory(String line) {
        this.history.push(line);
    }

    private void deleteWithMaskEnabled() throws IOException {
        if (this.consoleBuffer.getBuffer().getLineNoMask().length() > 0) {
            this.consoleBuffer.getBuffer().delete(this.consoleBuffer.getBuffer().getLineNoMask().length() - 1, this.consoleBuffer.getBuffer().getLineNoMask().length());
            this.consoleBuffer.moveCursor(this.consoleBuffer.getBuffer().getLineNoMask().length());
        }
    }

    private void printSearch(String searchTerm, String result) throws IOException {
        int cursor = result.indexOf(searchTerm);
        StringBuilder builder = this.history.getSearchDirection() == SearchDirection.REVERSE ? new StringBuilder("(reverse-i-search) `") : new StringBuilder("(forward-i-search) `");
        builder.append(searchTerm).append("': ");
        cursor += builder.length();
        builder.append(result);
        this.consoleBuffer.getBuffer().disablePrompt(true);
        this.consoleBuffer.moveCursor(-this.consoleBuffer.getBuffer().getCursor());
        this.consoleBuffer.out().print("\u001b[1G");
        this.consoleBuffer.out().print("\u001b[2K");
        this.consoleBuffer.setBufferLine(builder.toString());
        this.consoleBuffer.moveCursor(cursor);
        this.consoleBuffer.drawLine();
        this.consoleBuffer.getBuffer().disablePrompt(false);
        this.consoleBuffer.out().flush();
    }

    private void undo() throws IOException {
        UndoAction ua = this.consoleBuffer.getUndoManager().getNext();
        if (ua != null) {
            this.consoleBuffer.setBufferLine(ua.getBuffer());
            this.consoleBuffer.drawLine();
            this.consoleBuffer.moveCursor(ua.getCursorPosition() - this.consoleBuffer.getBuffer().getCursor());
        }
    }
}

