/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration.cli.commands;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.console.command.CommandException;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.keycloak.client.registration.cli.commands.AbstractAuthOptionsCmd;
import org.keycloak.client.registration.cli.config.ConfigData;
import org.keycloak.client.registration.cli.util.AuthUtil;
import org.keycloak.client.registration.cli.util.ConfigUtil;
import org.keycloak.client.registration.cli.util.HttpUtil;
import org.keycloak.client.registration.cli.util.IoUtil;
import org.keycloak.client.registration.cli.util.OsUtil;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.util.JsonSerialization;

@CommandDefinition(name="update-token", description="CLIENT [ARGUMENTS]")
public class UpdateTokenCmd
extends AbstractAuthOptionsCmd {
    @Arguments
    private List<String> args;

    public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        try {
            if (this.printHelp()) {
                CommandResult commandResult = this.help ? CommandResult.SUCCESS : CommandResult.FAILURE;
                return commandResult;
            }
            this.processGlobalOptions();
            if (this.args == null || this.args.isEmpty()) {
                throw new IllegalArgumentException("CLIENT not specified");
            }
            String clientId = this.args.get(0);
            if (clientId.startsWith("-")) {
                IoUtil.warnfOut("You're using what looks like an OPTION as CLIENT: %s", clientId);
            }
            ConfigData config = ConfigUtil.loadConfig();
            config = this.copyWithServerInfo(config);
            this.setupTruststore(config, commandInvocation);
            config = this.ensureAuthInfo(config, commandInvocation);
            String auth = AuthUtil.ensureToken(config);
            String cid = null;
            String server = config.getServerUrl();
            String realm = config.getRealm();
            InputStream response = HttpUtil.doGet(server + "/admin/realms/" + realm + "/clients", "application/json", "Bearer " + auth);
            try {
                List<ClientRepresentation> clients = JsonSerialization.readValue(response, new TypeReference<List<ClientRepresentation>>(){});
                for (ClientRepresentation client : clients) {
                    if (!clientId.equals(client.getClientId())) continue;
                    cid = client.getId();
                    break;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to process response from server", e);
            }
            if (cid == null) {
                throw new RuntimeException("No client found for: " + clientId);
            }
            response = HttpUtil.doPost(server + "/admin/realms/" + realm + "/clients/" + cid + "/registration-access-token", "application/json", "application/json", null, "Bearer " + auth);
            try {
                ClientRepresentation client = JsonSerialization.readValue(response, ClientRepresentation.class);
                if (this.noconfig) {
                    IoUtil.printOut(client.getRegistrationAccessToken());
                } else {
                    ConfigUtil.saveMergeConfig(cfg -> ConfigUtil.setRegistrationToken(cfg.ensureRealmConfigData(server, realm), client.getClientId(), client.getRegistrationAccessToken()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to process response from server", e);
            }
            CommandResult commandResult = CommandResult.SUCCESS;
            return commandResult;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + this.suggestHelp(), e);
        }
        finally {
            commandInvocation.stop();
        }
    }

    @Override
    protected boolean nothingToDo() {
        return this.noOptions() && (this.args == null || this.args.size() == 0);
    }

    protected String suggestHelp() {
        return OsUtil.EOL + "Try '" + OsUtil.CMD + " help update-token' for more information";
    }

    @Override
    protected String help() {
        return UpdateTokenCmd.usage();
    }

    public static String usage() {
        StringWriter sb = new StringWriter();
        PrintWriter out = new PrintWriter(sb);
        out.println("Usage: " + OsUtil.CMD + " update-token CLIENT [ARGUMENTS]");
        out.println();
        out.println("Command to reissue, and set a new registration access token if an old one is lost or becomes invalid.");
        out.println("It requires an authenticated session using an account with administrator priviliges.");
        out.println();
        out.println("Arguments:");
        out.println();
        out.println("  Global options:");
        out.println("    -x                    Print full stack trace when exiting with error");
        out.println("    --config              Path to the config file (" + ConfigUtil.DEFAULT_CONFIG_FILE_STRING + " by default)");
        out.println("    --truststore PATH     Path to a truststore containing trusted certificates");
        out.println("    --trustpass PASSWORD  Truststore password (prompted for if not specified and --truststore is used)");
        out.println("    CREDENTIALS OPTIONS   Same set of options as accepted by '" + OsUtil.CMD + " config credentials' in order to establish");
        out.println("                          an authenticated sessions. This allows on-the-fly transient authentication that leaves");
        out.println("                          no tokens in config file.");
        out.println();
        out.println("  Command specific options:");
        out.println("    CLIENT                ClientId of the client to reissue a new Registration Access Token for");
        out.println("                          The new token is saved to a config file or printed to stdout if on-the-fly\n");
        out.println("                          authentication is used");
        out.println();
        out.println("Examples:");
        out.println();
        out.println("Request a new Registration Access Token from the server using current authenticated session:");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " update-token my_client");
        out.println();
        out.println("Use '" + OsUtil.CMD + " help' for general information and a list of commands");
        return sb.toString();
    }
}

