/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.terminal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.reader.ConsoleInputSession;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.terminal.AbstractTerminal;
import org.jboss.aesh.terminal.TerminalSize;
import org.jboss.aesh.util.LoggerUtil;

public class POSIXTerminal
extends AbstractTerminal {
    private TerminalSize size;
    private boolean echoEnabled;
    private String ttyConfig;
    private String ttyProps;
    private long ttyPropsLastFetched;
    private boolean restored = false;
    private ConsoleInputSession input;
    private PrintStream stdOut;
    private PrintStream stdErr;
    private static final long TIMEOUT_PERIOD = 3000L;
    private static final Logger LOGGER = LoggerUtil.getLogger(POSIXTerminal.class.getName());

    public POSIXTerminal() {
        super(LOGGER);
    }

    @Override
    public void init(Settings settings) {
        this.settings = settings;
        try {
            this.ttyConfig = POSIXTerminal.stty("-g");
            if (this.ttyConfig.length() == 0 || !this.ttyConfig.contains("=") && !this.ttyConfig.contains(":")) {
                if (settings.isLogging()) {
                    LOGGER.log(Level.SEVERE, "Unrecognized stty code: " + this.ttyConfig);
                }
                throw new RuntimeException("Unrecognized stty code: " + this.ttyConfig);
            }
            if (Config.isCygwin()) {
                POSIXTerminal.stty("-ixon -icanon min 1 intr undef -echo");
            } else {
                if (Config.getOS().equalsIgnoreCase("hp-ux")) {
                    POSIXTerminal.stty("-ixon -icanon min 1");
                } else {
                    POSIXTerminal.stty("-ixon -icanon min 1 intr undef icrnl susp undef");
                }
                POSIXTerminal.stty("-echo");
            }
            this.echoEnabled = false;
        }
        catch (IOException ioe) {
            if (settings.isLogging()) {
                LOGGER.log(Level.SEVERE, "tty failed: ", ioe);
            }
        }
        catch (InterruptedException e) {
            if (settings.isLogging()) {
                LOGGER.log(Level.SEVERE, "failed while waiting for process to end: ", e);
            }
            e.printStackTrace();
        }
        this.input = new ConsoleInputSession(settings.getInputStream());
        this.stdOut = settings.getStdOut();
        this.stdErr = settings.getStdErr();
        this.size = new TerminalSize(this.getHeight(), this.getWidth());
    }

    @Override
    public int[] read() throws IOException {
        return this.input.readAll();
    }

    @Override
    public boolean hasInput() {
        return this.input.hasInput();
    }

    @Override
    public TerminalSize getSize() {
        if (this.propertiesTimedOut()) {
            this.size.setHeight(this.getHeight());
            this.size.setWidth(this.getWidth());
        }
        return this.size;
    }

    private int getHeight() {
        int height;
        block3: {
            height = 0;
            try {
                height = this.getTerminalProperty("rows");
            }
            catch (Exception e) {
                if (!this.settings.isLogging()) break block3;
                LOGGER.log(Level.SEVERE, "Failed to fetch terminal height: ", e);
            }
        }
        if (height < 1) {
            height = 24;
        }
        return height;
    }

    private int getWidth() {
        int width;
        block3: {
            width = 0;
            try {
                width = this.getTerminalProperty("columns");
            }
            catch (Exception e) {
                if (!this.settings.isLogging()) break block3;
                LOGGER.log(Level.SEVERE, "Failed to fetch terminal width: ", e);
            }
        }
        if (width < 1) {
            width = 80;
        }
        return width;
    }

    @Override
    public boolean isEchoEnabled() {
        return this.echoEnabled;
    }

    @Override
    public void reset() throws IOException {
        block3: {
            if (!this.restored && this.ttyConfig != null) {
                try {
                    POSIXTerminal.stty(this.ttyConfig);
                    this.ttyConfig = null;
                    this.restored = true;
                }
                catch (InterruptedException e) {
                    if (!this.settings.isLogging()) break block3;
                    LOGGER.log(Level.SEVERE, "Failed to reset terminal: ", e);
                }
            }
        }
    }

    @Override
    public void writeToInputStream(String data) {
        this.input.writeToInput(data);
    }

    @Override
    public void changeOutputStream(PrintStream output) {
        this.stdOut = output;
    }

    @Override
    public void close() throws IOException {
        this.input.stop();
    }

    private boolean propertiesTimedOut() {
        return System.currentTimeMillis() - this.ttyPropsLastFetched > 3000L;
    }

    private int getTerminalProperty(String prop) throws IOException, InterruptedException {
        if (this.ttyProps == null || this.propertiesTimedOut()) {
            this.ttyProps = POSIXTerminal.stty("-a");
            this.ttyPropsLastFetched = System.currentTimeMillis();
        }
        for (String str : this.ttyProps.split(";")) {
            if ((str = str.trim()).startsWith(prop)) {
                int index = str.lastIndexOf(" ");
                return Integer.parseInt(str.substring(index).trim());
            }
            if (!str.endsWith(prop)) continue;
            int index = str.indexOf(" ");
            return Integer.parseInt(str.substring(0, index).trim());
        }
        return -1;
    }

    protected static String stty(String args) throws IOException, InterruptedException {
        return POSIXTerminal.exec("stty " + args + " < /dev/tty").trim();
    }

    private static String exec(String cmd) throws IOException, InterruptedException {
        return POSIXTerminal.exec(new String[]{"sh", "-c", cmd});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String exec(String[] cmd) throws IOException, InterruptedException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Process p = Runtime.getRuntime().exec(cmd);
        InputStream in = null;
        InputStream err = null;
        OutputStream out = null;
        try {
            int c;
            in = p.getInputStream();
            while ((c = in.read()) != -1) {
                bout.write(c);
            }
            err = p.getErrorStream();
            while ((c = err.read()) != -1) {
                bout.write(c);
            }
            out = p.getOutputStream();
            p.waitFor();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (err != null) {
                    err.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to close streams: ", e);
            }
        }
        return new String(bout.toByteArray());
    }

    @Override
    public PrintStream err() {
        return this.stdErr;
    }

    @Override
    public PrintStream out() {
        return this.stdOut;
    }
}

