/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.terminal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.jboss.aesh.console.reader.AeshStandardStream;
import org.jboss.aesh.console.reader.ConsoleInputSession;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.terminal.CursorPosition;
import org.jboss.aesh.terminal.Shell;
import org.jboss.aesh.terminal.Terminal;
import org.jboss.aesh.terminal.TerminalSize;

public class TestTerminal
implements Terminal,
Shell {
    private PrintStream outWriter;
    private PrintStream errWriter;
    private TerminalSize size;
    private ConsoleInputSession input;
    private InputStream in;

    @Override
    public void init(Settings settings) {
        this.input = new ConsoleInputSession(settings.getInputStream());
        this.in = settings.getInputStream();
        this.outWriter = new PrintStream(settings.getStdOut(), true);
        this.errWriter = new PrintStream(settings.getStdErr(), true);
        this.size = new TerminalSize(24, 80);
    }

    @Override
    public int[] read() throws IOException {
        return this.input.readAll();
    }

    @Override
    public boolean hasInput() {
        return this.input.hasInput();
    }

    @Override
    public TerminalSize getSize() {
        return this.size;
    }

    @Override
    public CursorPosition getCursor() {
        return new CursorPosition(0, 0);
    }

    @Override
    public void setCursor(CursorPosition cp) {
    }

    @Override
    public void moveCursor(int r, int c) {
    }

    @Override
    public boolean isMainBuffer() {
        return true;
    }

    @Override
    public void enableAlternateBuffer() {
    }

    @Override
    public void enableMainBuffer() {
    }

    @Override
    public boolean isEchoEnabled() {
        return false;
    }

    @Override
    public void reset() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.input.stop();
    }

    @Override
    public Shell getShell() {
        return this;
    }

    @Override
    public void clear() throws IOException {
    }

    @Override
    public PrintStream err() {
        return this.errWriter;
    }

    @Override
    public AeshStandardStream in() {
        return new AeshStandardStream(new BufferedInputStream(this.in));
    }

    @Override
    public PrintStream out() {
        return this.outWriter;
    }

    @Override
    public void writeToInputStream(String data) {
        this.input.writeToInput(data);
    }

    @Override
    public void changeOutputStream(PrintStream output) {
        this.outWriter = output;
    }
}

