/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.RedirectionException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.ext.WriterInterceptor;
import org.jboss.resteasy.client.jaxrs.AsyncClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.internal.AbortedResponse;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ClientRequestContextImpl;
import org.jboss.resteasy.client.jaxrs.internal.ClientRequestHeaders;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponseContextImpl;
import org.jboss.resteasy.client.jaxrs.internal.proxy.ClientInvoker;
import org.jboss.resteasy.core.interception.ClientWriterInterceptorContext;
import org.jboss.resteasy.plugins.providers.sse.EventInput;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.DelegatingOutputStream;
import org.jboss.resteasy.util.Types;

public class ClientInvocation
implements Invocation {
    protected ResteasyClient client;
    protected ClientRequestHeaders headers;
    protected String method;
    protected Object entity;
    protected Type entityGenericType;
    protected Class<?> entityClass;
    protected Annotation[] entityAnnotations;
    protected ClientConfiguration configuration;
    protected URI uri;
    protected boolean chunked;
    protected ClientInvoker clientInvoker;
    protected DelegatingOutputStream delegatingOutputStream = new DelegatingOutputStream();
    protected OutputStream entityStream = this.delegatingOutputStream;

    public ClientInvocation(ResteasyClient client, URI uri, ClientRequestHeaders headers, ClientConfiguration parent) {
        this.uri = uri;
        this.client = client;
        this.configuration = new ClientConfiguration(parent);
        this.headers = headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T extractResult(GenericType<T> responseType, Response response, Annotation[] annotations) {
        int status = response.getStatus();
        if (status >= 200 && status < 300) {
            try {
                if (response.getMediaType() == null) {
                    T t = null;
                    return t;
                }
                T rtn = response.readEntity(responseType, annotations);
                if ((InputStream.class.isInstance(rtn) || Reader.class.isInstance(rtn) || EventInput.class.isInstance(rtn)) && response instanceof ClientResponse) {
                    ClientResponse clientResponse = (ClientResponse)response;
                    clientResponse.noReleaseConnection();
                }
                T t = rtn;
                return t;
            }
            catch (WebApplicationException wae) {
                try {
                    response.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw wae;
            }
            catch (Throwable throwable) {
                try {
                    response.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ResponseProcessingException(response, throwable);
            }
            finally {
                if (response.getMediaType() == null) {
                    response.close();
                }
            }
        }
        try {
            String s = (String)String.class.cast(response.getHeaders().getFirst("resteasy.buffer.exception.entity"));
            if (s == null || Boolean.parseBoolean(s)) {
                response.bufferEntity();
            } else if (response instanceof ClientResponse) {
                try {
                    ((ClientResponse)ClientResponse.class.cast(response)).releaseConnection();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (status >= 300 && status < 400) {
                throw new RedirectionException(response);
            }
            T t = ClientInvocation.handleErrorStatus(response);
            return t;
        }
        finally {
            if (response.getMediaType() == null) {
                response.close();
            }
        }
    }

    public static <T> T handleErrorStatus(Response response) {
        int status = response.getStatus();
        switch (status) {
            case 400: {
                throw new BadRequestException(response);
            }
            case 401: {
                throw new NotAuthorizedException(response);
            }
            case 403: {
                throw new ForbiddenException(response);
            }
            case 404: {
                throw new NotFoundException(response);
            }
            case 405: {
                throw new NotAllowedException(response);
            }
            case 406: {
                throw new NotAcceptableException(response);
            }
            case 415: {
                throw new NotSupportedException(response);
            }
            case 500: {
                throw new InternalServerErrorException(response);
            }
            case 503: {
                throw new ServiceUnavailableException(response);
            }
        }
        if (status >= 400 && status < 500) {
            throw new ClientErrorException(response);
        }
        if (status >= 500) {
            throw new ServerErrorException(response);
        }
        throw new WebApplicationException(response);
    }

    public ClientConfiguration getClientConfiguration() {
        return this.configuration;
    }

    public ResteasyClient getClient() {
        return this.client;
    }

    public DelegatingOutputStream getDelegatingOutputStream() {
        return this.delegatingOutputStream;
    }

    public void setDelegatingOutputStream(DelegatingOutputStream delegatingOutputStream) {
        this.delegatingOutputStream = delegatingOutputStream;
    }

    public OutputStream getEntityStream() {
        return this.entityStream;
    }

    public void setEntityStream(OutputStream entityStream) {
        this.entityStream = entityStream;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public Annotation[] getEntityAnnotations() {
        return this.entityAnnotations;
    }

    public void setEntityAnnotations(Annotation[] entityAnnotations) {
        this.entityAnnotations = entityAnnotations;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setHeaders(ClientRequestHeaders headers) {
        this.headers = headers;
    }

    public Map<String, Object> getMutableProperties() {
        return this.configuration.getMutableProperties();
    }

    public Object getEntity() {
        return this.entity;
    }

    public Type getEntityGenericType() {
        return this.entityGenericType;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public ClientRequestHeaders getHeaders() {
        return this.headers;
    }

    public void setEntity(Entity<?> entity) {
        if (entity == null) {
            this.entity = null;
            this.entityAnnotations = null;
            this.entityClass = null;
            this.entityGenericType = null;
        } else {
            Object ent = entity.getEntity();
            this.setEntityObject(ent);
            this.entityAnnotations = entity.getAnnotations();
            Variant v = entity.getVariant();
            this.headers.setMediaType(v.getMediaType());
            this.headers.setLanguage(v.getLanguage());
            this.headers.header("Content-Encoding", null);
            this.headers.header("Content-Encoding", v.getEncoding());
        }
    }

    public void setEntityObject(Object ent) {
        if (ent instanceof GenericEntity) {
            GenericEntity genericEntity = (GenericEntity)ent;
            this.entityClass = genericEntity.getRawType();
            this.entityGenericType = genericEntity.getType();
            this.entity = genericEntity.getEntity();
        } else if (ent == null) {
            this.entity = null;
            this.entityClass = null;
            this.entityGenericType = null;
        } else {
            this.entity = ent;
            this.entityClass = ent.getClass();
            this.entityGenericType = ent.getClass();
        }
    }

    public void writeRequestBody(OutputStream outputStream) throws IOException {
        if (this.entity == null) {
            return;
        }
        WriterInterceptor[] interceptors = this.getWriterInterceptors();
        ClientWriterInterceptorContext ctx = new ClientWriterInterceptorContext(interceptors, this.configuration.getProviderFactory(), this.entity, this.entityClass, this.entityGenericType, this.entityAnnotations, this.headers.getMediaType(), this.headers.getHeaders(), outputStream, this.getMutableProperties());
        ctx.proceed();
    }

    public WriterInterceptor[] getWriterInterceptors() {
        return this.configuration.getWriterInterceptors(null, null);
    }

    public ClientRequestFilter[] getRequestFilters() {
        return this.configuration.getRequestFilters(null, null);
    }

    public ClientResponseFilter[] getResponseFilters() {
        return this.configuration.getResponseFilters(null, null);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public void setChunked(boolean chunked) {
        this.chunked = chunked;
    }

    @Override
    public ClientResponse invoke() {
        Providers current = this.pushProvidersContext();
        try {
            ClientRequestContextImpl requestContext = new ClientRequestContextImpl(this);
            ClientResponse aborted = this.filterRequest(requestContext);
            ClientResponse response = aborted != null ? aborted : this.client.httpEngine().invoke(this);
            ClientResponse clientResponse = this.filterResponse(requestContext, response);
            return clientResponse;
        }
        catch (ResponseProcessingException e) {
            if (e.getResponse() != null) {
                e.getResponse().close();
            }
            throw e;
        }
        finally {
            this.popProvidersContext(current);
        }
    }

    @Override
    public <T> T invoke(Class<T> responseType) {
        ClientResponse response = this.invoke();
        if (Response.class.equals(responseType)) {
            return (T)response;
        }
        return ClientInvocation.extractResult(new GenericType(responseType), response, null);
    }

    @Override
    public <T> T invoke(GenericType<T> responseType) {
        ClientResponse response = this.invoke();
        if (responseType.getRawType().equals(Response.class)) {
            return (T)response;
        }
        return ClientInvocation.extractResult(responseType, response, null);
    }

    @Override
    public Future<Response> submit() {
        return this.doSubmit(false, null, new AsyncClientHttpEngine.ResultExtractor<Response>(){

            @Override
            public Response extractResult(ClientResponse response) {
                return response;
            }
        });
    }

    @Override
    public <T> Future<T> submit(final Class<T> responseType) {
        return this.doSubmit(false, null, new AsyncClientHttpEngine.ResultExtractor<T>(){

            @Override
            public T extractResult(ClientResponse response) {
                if (Response.class.equals((Object)responseType)) {
                    return response;
                }
                return ClientInvocation.extractResult(new GenericType(responseType), response, null);
            }
        });
    }

    @Override
    public <T> Future<T> submit(final GenericType<T> responseType) {
        return this.doSubmit(false, null, new AsyncClientHttpEngine.ResultExtractor<T>(){

            @Override
            public T extractResult(ClientResponse response) {
                if (responseType.getRawType().equals(Response.class)) {
                    return response;
                }
                return ClientInvocation.extractResult(responseType, response, null);
            }
        });
    }

    @Override
    public <T> Future<T> submit(InvocationCallback<T> callback) {
        GenericType<Object> genericType = new GenericType<Object>(){};
        Type[] typeInfo = Types.getActualTypeArgumentsOfAnInterface(callback.getClass(), InvocationCallback.class);
        if (typeInfo != null) {
            genericType = new GenericType(typeInfo[0]);
        }
        final GenericType<Object> responseType = genericType;
        return this.doSubmit(true, callback, new AsyncClientHttpEngine.ResultExtractor<T>(){

            @Override
            public T extractResult(ClientResponse response) {
                if (responseType.getRawType().equals(Response.class)) {
                    return response;
                }
                return ClientInvocation.extractResult(responseType, response, null);
            }
        });
    }

    @Override
    public Invocation property(String name, Object value) {
        this.configuration.property(name, value);
        return this;
    }

    public ClientInvoker getClientInvoker() {
        return this.clientInvoker;
    }

    public void setClientInvoker(ClientInvoker clientInvoker) {
        this.clientInvoker = clientInvoker;
    }

    private Providers pushProvidersContext() {
        Providers current = ResteasyProviderFactory.getContextData(Providers.class);
        ResteasyProviderFactory.pushContext(Providers.class, this.configuration);
        return current;
    }

    private void popProvidersContext(Providers current) {
        ResteasyProviderFactory.popContextData(Providers.class);
        if (current != null) {
            ResteasyProviderFactory.pushContext(Providers.class, current);
        }
    }

    private ClientResponse filterRequest(ClientRequestContextImpl requestContext) {
        ClientRequestFilter[] requestFilters = this.getRequestFilters();
        AbortedResponse aborted = null;
        if (requestFilters != null && requestFilters.length > 0) {
            for (ClientRequestFilter filter : requestFilters) {
                try {
                    filter.filter(requestContext);
                    if (requestContext.getAbortedWithResponse() == null) continue;
                    aborted = new AbortedResponse(this.configuration, requestContext.getAbortedWithResponse());
                    break;
                }
                catch (ProcessingException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new ProcessingException(e);
                }
            }
        }
        return aborted;
    }

    protected ClientResponse filterResponse(ClientRequestContextImpl requestContext, ClientResponse response) {
        response.setProperties(this.configuration.getMutableProperties());
        ClientResponseFilter[] responseFilters = this.getResponseFilters();
        if (responseFilters != null && responseFilters.length > 0) {
            ClientResponseContextImpl responseContext = new ClientResponseContextImpl(response);
            for (ClientResponseFilter filter : responseFilters) {
                try {
                    filter.filter(requestContext, responseContext);
                }
                catch (ResponseProcessingException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new ResponseProcessingException((Response)response, e);
                }
            }
        }
        return response;
    }

    private <T> Future<T> doSubmit(boolean buffered, InvocationCallback<T> callback, AsyncClientHttpEngine.ResultExtractor<T> extractor) {
        ClientHttpEngine httpEngine = this.client.httpEngine();
        if (httpEngine instanceof AsyncClientHttpEngine) {
            return this.asyncSubmit((AsyncClientHttpEngine)httpEngine, buffered, callback, extractor);
        }
        return this.executorSubmit(this.client.asyncInvocationExecutor(), callback, extractor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Future<T> asyncSubmit(AsyncClientHttpEngine asyncHttpEngine, boolean buffered, InvocationCallback<T> callback, final AsyncClientHttpEngine.ResultExtractor<T> extractor) {
        final ClientRequestContextImpl requestContext = new ClientRequestContextImpl(this);
        Providers current = this.pushProvidersContext();
        try {
            ClientResponse aborted = this.filterRequest(requestContext);
            if (aborted != null) {
                aborted = this.filterResponse(requestContext, aborted);
                T result = extractor.extractResult(aborted);
                this.callCompletedNoThrow(callback, result);
                CompletedFuture<T> completedFuture = new CompletedFuture<T>(result, null);
                return completedFuture;
            }
        }
        catch (Exception ex) {
            this.callFailedNoThrow(callback, ex);
            CompletedFuture<Object> completedFuture = new CompletedFuture<Object>(null, new ExecutionException(ex));
            return completedFuture;
        }
        finally {
            this.popProvidersContext(current);
        }
        return asyncHttpEngine.submit(this, buffered, callback, new AsyncClientHttpEngine.ResultExtractor<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T extractResult(ClientResponse response) {
                Providers current = ClientInvocation.this.pushProvidersContext();
                try {
                    Object t = extractor.extractResult(ClientInvocation.this.filterResponse(requestContext, response));
                    return t;
                }
                finally {
                    ClientInvocation.this.popProvidersContext(current);
                }
            }
        });
    }

    private <T> Future<T> executorSubmit(ExecutorService executor, final InvocationCallback<T> callback, final AsyncClientHttpEngine.ResultExtractor<T> extractor) {
        return executor.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                Object result = null;
                ClientResponse response = null;
                try {
                    response = ClientInvocation.this.invoke();
                    result = extractor.extractResult(response);
                    ClientInvocation.this.callCompletedNoThrow(callback, result);
                    Object t = result;
                    return t;
                }
                catch (Exception e) {
                    ClientInvocation.this.callFailedNoThrow(callback, e);
                    throw e;
                }
                finally {
                    if (response != null && callback != null) {
                        response.close();
                    }
                }
            }
        });
    }

    private <T> void callCompletedNoThrow(InvocationCallback<T> callback, T result) {
        if (callback != null) {
            try {
                callback.completed(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private <T> void callFailedNoThrow(InvocationCallback<T> callback, Exception exception) {
        if (callback != null) {
            try {
                callback.failed(exception);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    private static class CompletedFuture<T>
    implements Future<T> {
        private final T result;
        private final ExecutionException ex;

        public CompletedFuture(T result, ExecutionException ex) {
            this.ex = ex;
            this.result = result;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            if (this.ex != null) {
                throw this.ex;
            }
            return this.result;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }
    }
}

