/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.examples.authenticator.credential;

import java.io.IOException;
import org.keycloak.common.util.Time;
import org.keycloak.credential.CredentialModel;
import org.keycloak.examples.authenticator.credential.dto.SecretQuestionCredentialData;
import org.keycloak.examples.authenticator.credential.dto.SecretQuestionSecretData;
import org.keycloak.util.JsonSerialization;

public class SecretQuestionCredentialModel
extends CredentialModel {
    public static final String TYPE = "SECRET_QUESTION";
    private final SecretQuestionCredentialData credentialData;
    private final SecretQuestionSecretData secretData;

    private SecretQuestionCredentialModel(SecretQuestionCredentialData credentialData, SecretQuestionSecretData secretData) {
        this.credentialData = credentialData;
        this.secretData = secretData;
    }

    private SecretQuestionCredentialModel(String question, String answer) {
        this.credentialData = new SecretQuestionCredentialData(question);
        this.secretData = new SecretQuestionSecretData(answer);
    }

    public static SecretQuestionCredentialModel createSecretQuestion(String question, String answer) {
        SecretQuestionCredentialModel credentialModel = new SecretQuestionCredentialModel(question, answer);
        credentialModel.fillCredentialModelFields();
        return credentialModel;
    }

    public static SecretQuestionCredentialModel createFromCredentialModel(CredentialModel credentialModel) {
        try {
            SecretQuestionCredentialData credentialData = (SecretQuestionCredentialData)JsonSerialization.readValue((String)credentialModel.getCredentialData(), SecretQuestionCredentialData.class);
            SecretQuestionSecretData secretData = (SecretQuestionSecretData)JsonSerialization.readValue((String)credentialModel.getSecretData(), SecretQuestionSecretData.class);
            SecretQuestionCredentialModel secretQuestionCredentialModel = new SecretQuestionCredentialModel(credentialData, secretData);
            secretQuestionCredentialModel.setUserLabel(credentialModel.getUserLabel());
            secretQuestionCredentialModel.setCreatedDate(credentialModel.getCreatedDate());
            secretQuestionCredentialModel.setType(TYPE);
            secretQuestionCredentialModel.setId(credentialModel.getId());
            secretQuestionCredentialModel.setSecretData(credentialModel.getSecretData());
            secretQuestionCredentialModel.setCredentialData(credentialModel.getCredentialData());
            return secretQuestionCredentialModel;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SecretQuestionCredentialData getSecretQuestionCredentialData() {
        return this.credentialData;
    }

    public SecretQuestionSecretData getSecretQuestionSecretData() {
        return this.secretData;
    }

    private void fillCredentialModelFields() {
        try {
            this.setCredentialData(JsonSerialization.writeValueAsString((Object)this.credentialData));
            this.setSecretData(JsonSerialization.writeValueAsString((Object)this.secretData));
            this.setType(TYPE);
            this.setCreatedDate(Time.currentTimeMillis());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

