/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.beans;

import java.util.regex.Pattern;
import org.apache.mina.integration.beans.AbstractPropertyEditor;

public class CharacterEditor
extends AbstractPropertyEditor {
    private static final Pattern UNICODE = Pattern.compile("\\\\[uU][0-9a-fA-F]+");

    protected String toText(Object value) {
        return String.valueOf(value);
    }

    protected Object toValue(String text) throws IllegalArgumentException {
        if (text.length() == 0) {
            return Character.valueOf('\u0000');
        }
        if (UNICODE.matcher(text).matches()) {
            return Character.valueOf((char)Integer.parseInt(text.substring(2)));
        }
        if (text.length() != 1) {
            throw new IllegalArgumentException("Too many characters: " + text);
        }
        return Character.valueOf(text.charAt(0));
    }
}

