/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb3.ejb.strategy.model.base;

import com.sun.tools.xjc.generator.bean.field.GenericFieldRenderer;
import com.sun.tools.xjc.model.CAttributePropertyInfo;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CCustomizable;
import com.sun.tools.xjc.model.CCustomizations;
import com.sun.tools.xjc.model.CNonElement;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.TypeUse;
import jakarta.xml.bind.JAXBElement;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.xml.namespace.QName;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.Customizations;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.GeneratedId;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.Id;
import org.jvnet.hyperjaxb3.ejb.strategy.model.CreateDefaultIdPropertyInfos;
import org.jvnet.hyperjaxb3.ejb.strategy.model.ProcessModel;
import org.jvnet.hyperjaxb3.xjc.generator.bean.field.TransientSingleField;
import org.jvnet.hyperjaxb3.xjc.model.CExternalLeafInfo;
import org.jvnet.jaxb.annox.util.ClassUtils;

public class DefaultCreateDefaultIdPropertyInfos
implements CreateDefaultIdPropertyInfos {
    private boolean transientField;

    @Override
    public boolean isTransient() {
        return this.transientField;
    }

    @Override
    public void setTransient(boolean transientField) {
        this.transientField = transientField;
    }

    @Override
    public Collection<CPropertyInfo> process(ProcessModel context, CClassInfo classInfo) {
        CPropertyInfo propertyInfo = this.createPropertyInfo(context, classInfo);
        return Collections.singletonList(propertyInfo);
    }

    protected CPropertyInfo createPropertyInfo(ProcessModel context, CClassInfo classInfo) {
        GeneratedId cid = context.getCustomizing().getGeneratedId(classInfo);
        String propertyName = this.getPropertyName(context, cid);
        QName attributeName = this.getAttributeName(context, cid);
        CNonElement propertyTypeInfo = this.getPropertyTypeInfo(context, cid);
        CCustomizations customizations = new CCustomizations();
        CPluginCustomization id = this.createIdCustomization(context, cid);
        customizations.add((Object)id);
        CAttributePropertyInfo propertyInfo = new CAttributePropertyInfo(propertyName, null, customizations, null, attributeName, (TypeUse)propertyTypeInfo, propertyTypeInfo.getTypeName(), false);
        if (cid.isTransient() != null && cid.isTransient().booleanValue()) {
            propertyInfo.realization = new GenericFieldRenderer(TransientSingleField.class);
        }
        Customizations.markGenerated((CCustomizable)propertyInfo);
        return propertyInfo;
    }

    public String getPropertyName(ProcessModel context, GeneratedId id) {
        String name = id.getName();
        Objects.requireNonNull(name, "The hj:id/@name attribute must not be null.");
        if (name.isEmpty()) {
            throw new IllegalArgumentException("The hj:id/@name attribute must not be empty.");
        }
        return name;
    }

    public QName getAttributeName(ProcessModel context, GeneratedId id) {
        QName attributeName = id.getAttributeName();
        return attributeName != null ? attributeName : new QName(this.getPropertyName(context, id));
    }

    public CNonElement getPropertyTypeInfo(ProcessModel context, GeneratedId id) {
        String javaType = id.getJavaType();
        Objects.requireNonNull(javaType, "The hj:id/@javaType attribute must not be null.");
        if (javaType.isEmpty()) {
            throw new IllegalArgumentException("The hj:id/@javaType attribute must not be empty.");
        }
        QName schemaType = id.getSchemaType();
        Objects.requireNonNull(schemaType, "The hj:id/@schemaType attribute must not be null.");
        try {
            Class theClass = ClassUtils.forName((String)javaType);
            return new CExternalLeafInfo(theClass, schemaType, null);
        }
        catch (ClassNotFoundException cnfex) {
            throw new IllegalArgumentException("Class name [" + javaType + "] provided in the hj:id/@javaType attribute could not be resolved.", cnfex);
        }
    }

    public CPluginCustomization createIdCustomization(ProcessModel context, GeneratedId generatedId) {
        Id id = new Id();
        id.mergeFrom((Object)generatedId, (Object)id);
        JAXBElement idElement = Customizations.getCustomizationsObjectFactory().createId(id);
        return Customizations.createCustomization((Object)idElement);
    }
}

