/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb3.ejb.strategy.processor;

import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.ns.persistence.Persistence;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.jvnet.hyperjaxb3.ejb.plugin.EjbPlugin;
import org.jvnet.hyperjaxb3.ejb.strategy.naming.Naming;
import org.jvnet.hyperjaxb3.ejb.strategy.outline.OutlineProcessor;
import org.jvnet.hyperjaxb3.ejb.strategy.processor.ClassPersistenceUnitFactory;
import org.jvnet.hyperjaxb3.ejb.strategy.processor.PersistenceFactory;
import org.jvnet.hyperjaxb3.ejb.strategy.processor.PersistenceMarshaller;
import org.jvnet.hyperjaxb3.ejb.strategy.processor.PersistenceUnitFactory;
import org.jvnet.hyperjaxb3.persistence.util.PersistenceUtils;
import org.jvnet.jaxb.lang.JAXBMergeCollectionsStrategy;
import org.jvnet.jaxb.lang.MergeStrategy;

public class ClassPersistenceProcessor
implements OutlineProcessor<EjbPlugin> {
    private Naming naming;
    private PersistenceFactory persistenceFactory;
    private PersistenceMarshaller persistenceMarshaller;
    private OutlineProcessor<EjbPlugin> outlineProcessor;
    private PersistenceUnitFactory persistenceUnitFactory = new ClassPersistenceUnitFactory();

    public Naming getNaming() {
        return this.naming;
    }

    public void setNaming(Naming naming) {
        this.naming = naming;
    }

    public PersistenceFactory getPersistenceFactory() {
        return this.persistenceFactory;
    }

    public void setPersistenceFactory(PersistenceFactory persistenceFactory) {
        this.persistenceFactory = persistenceFactory;
    }

    public PersistenceMarshaller getPersistenceMarshaller() {
        return this.persistenceMarshaller;
    }

    public void setPersistenceMarshaller(PersistenceMarshaller persistenceMarshaller) {
        this.persistenceMarshaller = persistenceMarshaller;
    }

    @Override
    public Collection<ClassOutline> process(EjbPlugin plugin, Outline outline, Options options) throws Exception {
        Collection<ClassOutline> includedClasses = this.getOutlineProcessor().process(plugin, outline, options);
        String pun = plugin.getPersistenceUnitName();
        String persistenceUnitName = pun != null ? pun : this.getNaming().getPersistenceUnitName(plugin.getMapping(), outline);
        Persistence.PersistenceUnit persistenceUnit = this.getPersistenceUnitFactory().createPersistenceUnit(includedClasses);
        Persistence persistence = this.createPersistence(plugin, persistenceUnit, persistenceUnitName);
        this.getPersistenceMarshaller().marshallPersistence(outline.getCodeModel(), persistence);
        return includedClasses;
    }

    protected Persistence createPersistence(EjbPlugin plugin, Persistence.PersistenceUnit persistenceUnit, String persistenceUnitName) throws JAXBException {
        Persistence.PersistenceUnit targetPersistenceUnit;
        Persistence persistence;
        File persistenceXml = plugin.getPersistenceXml();
        if (persistenceXml != null) {
            try {
                persistence = (Persistence)PersistenceUtils.CONTEXT.createUnmarshaller().unmarshal(persistenceXml);
                Persistence.PersistenceUnit foundPersistenceUnit = null;
                for (Persistence.PersistenceUnit unit : persistence.getPersistenceUnit()) {
                    if (persistenceUnitName != null && persistenceUnitName.equals(unit.getName())) {
                        foundPersistenceUnit = unit;
                        continue;
                    }
                    if (!"##generated".equals(unit.getName())) continue;
                    foundPersistenceUnit = unit;
                }
                if (foundPersistenceUnit != null) {
                    targetPersistenceUnit = foundPersistenceUnit;
                }
                targetPersistenceUnit = new Persistence.PersistenceUnit();
                persistence.getPersistenceUnit().add(targetPersistenceUnit);
            }
            catch (Exception ex) {
                throw new JAXBException("Persistence XML file [" + persistenceXml + "] could not be parsed.", (Throwable)ex);
            }
        } else {
            persistence = this.getPersistenceFactory().createPersistence();
            targetPersistenceUnit = new Persistence.PersistenceUnit();
            persistence.getPersistenceUnit().add(targetPersistenceUnit);
        }
        targetPersistenceUnit.mergeFrom(null, null, (Object)persistenceUnit, (Object)targetPersistenceUnit, (MergeStrategy)JAXBMergeCollectionsStrategy.INSTANCE);
        targetPersistenceUnit.setName(persistenceUnitName);
        Collections.sort(targetPersistenceUnit.getClazz());
        Collections.sort(targetPersistenceUnit.getClazz());
        return persistence;
    }

    public OutlineProcessor<EjbPlugin> getOutlineProcessor() {
        return this.outlineProcessor;
    }

    public void setOutlineProcessor(OutlineProcessor<EjbPlugin> outlineProcessor) {
        this.outlineProcessor = outlineProcessor;
    }

    public PersistenceUnitFactory getPersistenceUnitFactory() {
        return this.persistenceUnitFactory;
    }

    public void setPersistenceUnitFactory(PersistenceUnitFactory persistenceUnitFactory) {
        this.persistenceUnitFactory = persistenceUnitFactory;
    }
}

