/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb3.ejb.plugin;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.generator.bean.BeanGenerator;
import com.sun.tools.xjc.generator.bean.ClassOutlineImpl;
import com.sun.tools.xjc.generator.bean.field.FieldRenderer;
import com.sun.tools.xjc.generator.bean.field.FieldRendererFactory;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.reader.Ring;
import com.sun.tools.xjc.reader.xmlschema.BGMBuilder;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.LocalScoping;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jvnet.hyperjaxb3.ejb.IApplicationContext;
import org.jvnet.hyperjaxb3.ejb.plugin.ApplicationContext;
import org.jvnet.hyperjaxb3.ejb.schemas.customizations.Customizations;
import org.jvnet.hyperjaxb3.ejb.strategy.mapping.Mapping;
import org.jvnet.hyperjaxb3.ejb.strategy.naming.Naming;
import org.jvnet.hyperjaxb3.ejb.strategy.processor.ModelAndOutlineProcessor;
import org.jvnet.hyperjaxb3.ejb.test.RoundtripTest;
import org.jvnet.hyperjaxb3.xjc.generator.bean.field.UntypedListFieldRenderer;
import org.jvnet.jaxb.plugin.AbstractParameterizablePlugin;
import org.jvnet.jaxb.util.CustomizationUtils;
import org.jvnet.jaxb.util.GeneratorContextUtils;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;

public class EjbPlugin
extends AbstractParameterizablePlugin {
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final Method generateFieldDecl;
    private List<URL> episodeURLs;
    private String roundtripTestClassName;
    private String persistenceUnitName;
    private File targetDir;
    private File persistenceXml;
    public String applicationContextClassName;
    public IApplicationContext applicationContext;
    private Integer maxIdentifierLength;
    private String result;
    private String[] mergePersistenceUnits;
    private ModelAndOutlineProcessor<EjbPlugin> modelAndOutlineProcessor;
    private Mapping mapping;
    private Naming naming;
    private Collection<ClassOutline> includedClasses;
    private Collection<CClassInfo> createdClasses;
    private Map<CPropertyInfo, CClassInfo> createdProperties;
    private BGMBuilder bgmBuilder;

    public EjbPlugin() {
        try {
            this.generateFieldDecl = BeanGenerator.class.getDeclaredMethod("generateFieldDecl", ClassOutlineImpl.class, CPropertyInfo.class);
            this.generateFieldDecl.setAccessible(true);
        }
        catch (Exception ex) {
            throw new ExceptionInInitializerError(ex);
        }
        this.episodeURLs = new LinkedList<URL>();
        this.applicationContextClassName = null;
        this.maxIdentifierLength = null;
        this.result = "annotations";
        this.mergePersistenceUnits = new String[0];
        this.createdClasses = new LinkedList<CClassInfo>();
        this.createdProperties = new HashMap<CPropertyInfo, CClassInfo>();
    }

    public String getOptionName() {
        return "Xhyperjaxb3-ejb";
    }

    public String getUsage() {
        return "  -Xhyperjaxb3-ejb: Hyperjaxb3 EJB plugin";
    }

    public String getRoundtripTestClassName() {
        return this.roundtripTestClassName;
    }

    public void setRoundtripTestClassName(String rt) {
        this.roundtripTestClassName = rt;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public File getTargetDir() {
        return this.targetDir;
    }

    public void setTargetDir(File targetDir) {
        this.targetDir = targetDir;
    }

    public File getPersistenceXml() {
        return this.persistenceXml;
    }

    public void setPersistenceXml(File persistenceXml) {
        this.persistenceXml = persistenceXml;
    }

    public String getApplicationContextClassName() {
        return this.applicationContextClassName;
    }

    public void setApplicationContextClassName(String applicationContextClassName) {
        this.applicationContextClassName = applicationContextClassName;
    }

    public IApplicationContext getApplicationContext() {
        if (this.applicationContext == null) {
            this.applicationContext = this.createApplicationContext();
            if (this.getApplicationContextClassName() != null) {
                try {
                    this.applicationContext.setDelegate((IApplicationContext)Class.forName(this.getApplicationContextClassName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this.applicationContext;
    }

    private IApplicationContext createApplicationContext() {
        return new ApplicationContext();
    }

    public void setApplicationContext(IApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Integer getMaxIdentifierLength() {
        return this.maxIdentifierLength;
    }

    public void setMaxIdentifierLength(Integer maxIdentifierLength) {
        this.maxIdentifierLength = maxIdentifierLength;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String variant) {
        this.result = variant;
    }

    public String getModelAndOutlineProcessorBeanName() {
        return this.getResult();
    }

    public String[] getMergePersistenceUnits() {
        return this.mergePersistenceUnits;
    }

    public void setMergePersistenceUnits(String[] mergePersistenceUnits) {
        this.mergePersistenceUnits = mergePersistenceUnits;
    }

    public int parseArgument(Options opt, String[] args, int start) throws BadCommandLineException, IOException {
        int result = super.parseArgument(opt, args, start);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].length() == 0 || args[i].charAt(0) == '-' || !args[i].endsWith(".jar")) continue;
            this.episodeURLs.add(new File(args[i]).toURI().toURL());
        }
        return result;
    }

    public boolean run(Outline outline, Options options) throws Exception {
        Ring ring = Ring.begin();
        try {
            Ring.add((Object)this.bgmBuilder);
            Ring.add((Object)outline.getModel());
            ModelAndOutlineProcessor<EjbPlugin> modelAndOutlineProcessor = this.getModelAndOutlineProcessor();
            modelAndOutlineProcessor.process(this, outline.getModel(), options);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        finally {
            Ring.end((Ring)ring);
        }
        for (CClassInfo classInfo : this.getCreatedClasses()) {
            ClassOutline classOutline = outline.getClazz(classInfo);
            if (Customizations.isGenerated((CClassInfo)classInfo)) {
                this.generateClassBody(outline, (ClassOutlineImpl)classOutline);
            }
            for (CPropertyInfo propertyInfo : classInfo.getProperties()) {
                if (outline.getField(propertyInfo) != null) continue;
                this.generateFieldDecl(outline, (ClassOutlineImpl)classOutline, propertyInfo);
            }
        }
        this.modelAndOutlineProcessor.process(this, outline, options);
        this.generateRoundtripTestClass(outline);
        this.checkCustomizations(outline);
        return true;
    }

    private void generateRoundtripTestClass(Outline outline) {
        if (this.getRoundtripTestClassName() != null) {
            JDefinedClass roundtripTestClass = GeneratorContextUtils.generateContextPathAwareClass((Outline)outline, (String)this.getRoundtripTestClassName(), RoundtripTest.class);
            String persistenceUnitName = this.getPersistenceUnitName() != null ? this.getPersistenceUnitName() : this.getNaming().getPersistenceUnitName(this.getMapping(), outline);
            JMethod getPersistenceUnitName = roundtripTestClass.method(1, (JType)outline.getCodeModel().ref(String.class), "getPersistenceUnitName");
            getPersistenceUnitName.body()._return(JExpr.lit((String)persistenceUnitName));
        }
    }

    private void checkCustomizations(Outline outline) {
        for (CClassInfo classInfo : outline.getModel().beans().values()) {
            this.checkCustomizations(classInfo);
            for (CPropertyInfo propertyInfo : classInfo.getProperties()) {
                this.checkCustomizations(classInfo, propertyInfo);
            }
        }
    }

    private void checkCustomizations(CClassInfo classInfo, CPropertyInfo customizable) {
        for (CPluginCustomization pluginCustomization : CustomizationUtils.getCustomizations((CPropertyInfo)customizable)) {
            if (pluginCustomization.isAcknowledged() || !"urn:hyperjaxb3.jvnet.org:ejb:schemas:customizations".equals(pluginCustomization.element.getNamespaceURI())) continue;
            this.logger.warn((Object)("Unacknowledged customization [" + this.getName(pluginCustomization.element) + "] in the property [" + classInfo.getName() + "." + customizable.getName(true) + "]."));
            pluginCustomization.markAsAcknowledged();
        }
    }

    private void checkCustomizations(CClassInfo customizable) {
        for (CPluginCustomization pluginCustomization : CustomizationUtils.getCustomizations((CClassInfo)customizable)) {
            Element element = pluginCustomization.element;
            if (pluginCustomization.isAcknowledged()) continue;
            this.logger.warn((Object)("Unacknowledged customization [" + this.getName(element) + "] in the class [" + customizable.getName() + "]."));
            pluginCustomization.markAsAcknowledged();
        }
    }

    private QName getName(Element element) {
        return new QName(element.getNamespaceURI(), element.getLocalName(), element.getPrefix() == null ? "" : element.getPrefix());
    }

    public void postProcessModel(Model model, ErrorHandler errorHandler) {
        boolean serializable;
        this.bgmBuilder = (BGMBuilder)Ring.get(BGMBuilder.class);
        if (LocalScoping.NESTED.equals((Object)this.bgmBuilder.getGlobalBinding().getFlattenClasses())) {
            this.logger.warn((Object)"According to the Java Persistence API specification, section 2.1, entities must be top-level classes:\n\"The entity class must be a top-level class.\"\nYour JAXB model is not customized as with top-level local scoping, please use the <jaxb:globalBinding localScoping=\"toplevel\"/> global bindings customization.");
        }
        if (!(serializable = model.serializable)) {
            this.logger.warn((Object)"According to the Java Persistence API specification, section 2.1, entities must implement the serializable interface:\n\"If an entity instance is to be passed by value as a detached object\n(e.g., through a remote interface), the entity class must implement\n the Serializable interface.\"\nYour JAXB model is not customized as serializable, please use the <jaxb:serializable/> global bindings customization element to make your model serializable.");
        }
    }

    public void onActivated(Options options) throws BadCommandLineException {
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        super.onActivated(options);
        FieldRendererFactory fieldRendererFactory = new FieldRendererFactory(){

            public FieldRenderer getList(JClass coreList) {
                return new UntypedListFieldRenderer(coreList);
            }
        };
        options.setFieldRendererFactory(fieldRendererFactory, (Plugin)this);
    }

    protected void beforeRun(Outline outline, Options options) throws Exception {
        super.beforeRun(outline, options);
        if (this.getModelAndOutlineProcessor() == null) {
            ModelAndOutlineProcessor<EjbPlugin> modelAndOutlineProcessor = this.getApplicationContext().getModelAndOutlineProcessor(this.getModelAndOutlineProcessorBeanName());
            this.setModelAndOutlineProcessor(modelAndOutlineProcessor);
        }
        if (this.getNaming() == null) {
            this.setNaming(this.getApplicationContext().getNaming());
        }
        if (this.getMaxIdentifierLength() != null) {
            this.getNaming().setMaxIdentifierLength(this.getMaxIdentifierLength());
        }
        if (this.getMapping() == null) {
            this.setMapping(this.getApplicationContext().getMapping());
        }
        if (this.getTargetDir() == null) {
            this.setTargetDir(options.targetDir);
        }
    }

    public ModelAndOutlineProcessor<EjbPlugin> getModelAndOutlineProcessor() {
        return this.modelAndOutlineProcessor;
    }

    public void setModelAndOutlineProcessor(ModelAndOutlineProcessor<EjbPlugin> modelAndOutlineProcessor) {
        this.modelAndOutlineProcessor = modelAndOutlineProcessor;
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public void setMapping(Mapping mapping) {
        this.mapping = mapping;
    }

    public Naming getNaming() {
        return this.naming;
    }

    public void setNaming(Naming naming) {
        this.naming = naming;
    }

    public List<String> getCustomizationURIs() {
        LinkedList<String> customizationURIs = new LinkedList<String>();
        customizationURIs.addAll(super.getCustomizationURIs());
        customizationURIs.addAll(Customizations.NAMESPACES);
        return customizationURIs;
    }

    public boolean isCustomizationTagName(String namespace, String localPart) {
        return super.isCustomizationTagName(namespace, localPart) || Customizations.NAMESPACES.contains(namespace);
    }

    public Collection<ClassOutline> getIncludedClasses() {
        return this.includedClasses;
    }

    public void setIncludedClasses(Collection<ClassOutline> includedClasses) {
        this.includedClasses = includedClasses;
    }

    public Collection<CClassInfo> getCreatedClasses() {
        return this.createdClasses;
    }

    public Map<CPropertyInfo, CClassInfo> getCreatedProperties() {
        return this.createdProperties;
    }

    private void generateClassBody(Outline outline, ClassOutlineImpl cc) {
        JCodeModel codeModel = outline.getCodeModel();
        Model model = outline.getModel();
        CClassInfo target = cc.target;
        if (model.serializable) {
            cc.implClass._implements(Serializable.class);
            if (model.serialVersionUID != null) {
                cc.implClass.field(28, (JType)codeModel.LONG, "serialVersionUID", JExpr.lit((long)model.serialVersionUID));
            }
        }
        for (CPropertyInfo prop : target.getProperties()) {
            this.generateFieldDecl(outline, cc, prop);
        }
        assert (!target.declaresAttributeWildcard());
    }

    private FieldOutline generateFieldDecl(Outline outline, ClassOutlineImpl cc, CPropertyInfo prop) {
        try {
            return (FieldOutline)this.generateFieldDecl.invoke((Object)outline, cc, prop);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }
}

