/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb3.ejb.strategy.mapping;

import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CEnumLeafInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CTypeInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.xml.xsom.XSComponent;
import jakarta.persistence.EnumType;
import jakarta.xml.ns.persistence.orm.AttributeOverride;
import jakarta.xml.ns.persistence.orm.Basic;
import jakarta.xml.ns.persistence.orm.Column;
import jakarta.xml.ns.persistence.orm.EmbeddableAttributes;
import jakarta.xml.ns.persistence.orm.Embedded;
import jakarta.xml.ns.persistence.orm.Lob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jvnet.hyperjaxb3.codemodel.util.JTypeUtils;
import org.jvnet.hyperjaxb3.ejb.strategy.mapping.AttributeMapping;
import org.jvnet.hyperjaxb3.ejb.strategy.mapping.Mapping;
import org.jvnet.hyperjaxb3.xsd.util.XMLSchemaConstrants;
import org.jvnet.hyperjaxb3.xsom.SimpleTypeAnalyzer;
import org.jvnet.hyperjaxb3.xsom.TypeUtils;
import org.jvnet.jaxb.util.FieldAccessorUtils;

public final class DefaultAttributeMapping
implements AttributeMapping {
    @Override
    public final Column createColumn(Mapping context, FieldOutline fieldOutline, Column column) {
        if (column == null) {
            column = new Column();
        }
        if (column.getName() == null || "##default".equals(column.getName())) {
            column.setName(context.getNaming().getColumn$Name(context, fieldOutline));
        }
        this.assignColumn$LengthPrecisionScale(fieldOutline, column);
        return column;
    }

    private void assignColumn$LengthPrecisionScale(FieldOutline fieldOutline, Column column) {
        Integer defaultPrecision;
        if (column.getLength() == null) {
            column.setLength(this.createColumn$Length(fieldOutline));
        }
        Integer precision = this.createColumn$Precision(fieldOutline);
        Integer scale = this.createColumn$Scale(fieldOutline);
        if (precision != null && precision != 0) {
            column.setPrecision(precision);
        } else if (scale != null && scale != 0 && (defaultPrecision = column.getPrecision()) != null) {
            Integer defaultScale = column.getScale();
            int integerDigits = defaultPrecision - (defaultScale == null ? 0 : defaultScale);
            column.setPrecision(Integer.valueOf(integerDigits + scale));
            column.setScale(scale);
        }
        if (scale != null && scale != 0) {
            column.setScale(scale);
        }
    }

    public Integer createColumn$Precision(FieldOutline fieldOutline) {
        Long totalDigits = SimpleTypeAnalyzer.getTotalDigits(fieldOutline.getPropertyInfo().getSchemaComponent());
        Long fractionDigits = SimpleTypeAnalyzer.getFractionDigits(fieldOutline.getPropertyInfo().getSchemaComponent());
        Integer precision = totalDigits != null ? (fractionDigits != null ? Integer.valueOf(totalDigits.intValue() + fractionDigits.intValue()) : Integer.valueOf(totalDigits.intValue() * 2)) : null;
        return precision;
    }

    public Integer createColumn$Scale(FieldOutline fieldOutline) {
        Long fractionDigits = SimpleTypeAnalyzer.getFractionDigits(fieldOutline.getPropertyInfo().getSchemaComponent());
        Long totalDigits = SimpleTypeAnalyzer.getTotalDigits(fieldOutline.getPropertyInfo().getSchemaComponent());
        Integer scale = fractionDigits != null ? Integer.valueOf(fractionDigits.intValue()) : (totalDigits != null ? Integer.valueOf(totalDigits.intValue()) : null);
        return scale;
    }

    public Integer createColumn$Length(FieldOutline fieldOutline) {
        int intMinLength;
        Long minLength;
        Long maxLength;
        Long length = SimpleTypeAnalyzer.getLength(fieldOutline.getPropertyInfo().getSchemaComponent());
        Integer finalLength = length != null ? Integer.valueOf(length.intValue()) : ((maxLength = SimpleTypeAnalyzer.getMaxLength(fieldOutline.getPropertyInfo().getSchemaComponent())) != null ? Integer.valueOf(maxLength.intValue()) : ((minLength = SimpleTypeAnalyzer.getMinLength(fieldOutline.getPropertyInfo().getSchemaComponent())) != null ? ((intMinLength = minLength.intValue()) > 127 ? Integer.valueOf(intMinLength * 2) : null) : null));
        return finalLength;
    }

    @Override
    public boolean isTemporal(Mapping context, FieldOutline fieldOutline) {
        JMethod getter = FieldAccessorUtils.getter((FieldOutline)fieldOutline);
        JType type = getter.type();
        return JTypeUtils.isTemporalType(type);
    }

    @Override
    public String createTemporalType(Mapping context, FieldOutline fieldOutline) {
        JMethod getter = FieldAccessorUtils.getter((FieldOutline)fieldOutline);
        JType type = getter.type();
        JCodeModel codeModel = type.owner();
        if (codeModel.ref(Time.class).equals(type)) {
            return "TIME";
        }
        if (codeModel.ref(Date.class).equals(type)) {
            return "DATE";
        }
        if (codeModel.ref(Timestamp.class).equals(type)) {
            return "TIMESTAMP";
        }
        if (codeModel.ref(Calendar.class).equals(type)) {
            return "TIMESTAMP";
        }
        XSComponent schemaComponent = fieldOutline.getPropertyInfo().getSchemaComponent();
        List<Object> typeNames = schemaComponent != null ? TypeUtils.getTypeNames(schemaComponent) : Collections.emptyList();
        if (typeNames.contains(XMLSchemaConstrants.DATE_QNAME) || typeNames.contains(XMLSchemaConstrants.G_YEAR_MONTH_QNAME) || typeNames.contains(XMLSchemaConstrants.G_YEAR_QNAME) || typeNames.contains(XMLSchemaConstrants.G_MONTH_QNAME) || typeNames.contains(XMLSchemaConstrants.G_MONTH_DAY_QNAME) || typeNames.contains(XMLSchemaConstrants.G_DAY_QNAME)) {
            return "DATE";
        }
        if (typeNames.contains(XMLSchemaConstrants.TIME_QNAME)) {
            return "TIME";
        }
        if (typeNames.contains(XMLSchemaConstrants.DATE_TIME_QNAME)) {
            return "TIMESTAMP";
        }
        return "TIMESTAMP";
    }

    @Override
    public final boolean isLob(Mapping context, FieldOutline fieldOutline) {
        return false;
    }

    @Override
    public final Lob createLob(Mapping context, FieldOutline fieldOutline) {
        return new Lob();
    }

    @Override
    public final boolean isEnumerated(Mapping context, FieldOutline fieldOutline) {
        CPropertyInfo propertyInfo = fieldOutline.getPropertyInfo();
        Collection types = (Collection)context.getGetTypes().process(context, propertyInfo);
        assert (types.size() == 1);
        CTypeInfo type = (CTypeInfo)types.iterator().next();
        return type instanceof CEnumLeafInfo;
    }

    @Override
    public String createEnumerated(Mapping context, FieldOutline fieldOutline) {
        return EnumType.STRING.name();
    }

    @Override
    public void createAttributeOverride(Mapping context, FieldOutline fieldOutline, List<AttributeOverride> attributeOverrides) {
        CPropertyInfo propertyInfo = fieldOutline.getPropertyInfo();
        Collection types = (Collection)context.getGetTypes().process(context, propertyInfo);
        assert (types.size() == 1);
        CTypeInfo typeInfo = (CTypeInfo)types.iterator().next();
        assert (typeInfo instanceof CClassInfo);
        CClassInfo classInfo = (CClassInfo)typeInfo;
        Outline outline = fieldOutline.parent().parent();
        ClassOutline classOutline = outline.getClazz(classInfo);
        Options options = outline.getModel().options;
        HashMap<String, AttributeOverride> attributeOverridesMap = new HashMap<String, AttributeOverride>();
        for (AttributeOverride attributeOverride : attributeOverrides) {
            attributeOverridesMap.put(attributeOverride.getName(), attributeOverride);
        }
        Mapping embeddedMapping = context.createEmbeddedMapping(context, fieldOutline);
        EmbeddableAttributes embeddableAttributes = embeddedMapping.getEmbeddableAttributesMapping().process(embeddedMapping, classOutline, options);
        for (Basic basic : embeddableAttributes.getBasic()) {
            AttributeOverride attributeOverride;
            String name = basic.getName();
            if (!attributeOverridesMap.containsKey(name)) {
                attributeOverride = new AttributeOverride();
                attributeOverride.setName(name);
                attributeOverride.setColumn(basic.getColumn());
                attributeOverridesMap.put(name, attributeOverride);
                attributeOverrides.add(attributeOverride);
            } else {
                attributeOverride = (AttributeOverride)attributeOverridesMap.get(name);
            }
            if (attributeOverride.getColumn() != null) continue;
            attributeOverride.setColumn(new Column());
        }
        for (Embedded embedded : embeddableAttributes.getEmbedded()) {
            String parentName = embedded.getName();
            for (AttributeOverride embeddedAttributeOverride : embedded.getAttributeOverride()) {
                AttributeOverride attributeOverride;
                String childName = embeddedAttributeOverride.getName();
                String name = parentName + "." + childName;
                if (!attributeOverridesMap.containsKey(name)) {
                    attributeOverride = new AttributeOverride();
                    attributeOverride.setName(name);
                    attributeOverride.setColumn(embeddedAttributeOverride.getColumn());
                    attributeOverridesMap.put(name, attributeOverride);
                    attributeOverrides.add(attributeOverride);
                } else {
                    attributeOverride = (AttributeOverride)attributeOverridesMap.get(name);
                }
                if (attributeOverride.getColumn() != null) continue;
                attributeOverride.setColumn(new Column());
            }
        }
    }
}

