/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cppncss;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.ProminentProjectAction;
import hudson.plugins.cppncss.AbstractBuildReport;
import hudson.plugins.cppncss.PluginImpl;
import hudson.plugins.cppncss.parser.StatisticsResult;
import hudson.plugins.cppncss.parser.StatisticsTotalResult;
import hudson.plugins.helpers.AbstractProjectAction;
import hudson.plugins.helpers.GraphHelper;
import hudson.util.ChartUtil;
import java.io.IOException;
import java.util.Calendar;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProjectReport<T extends AbstractProject<?, ?>>
extends AbstractProjectAction<T>
implements ProminentProjectAction {
    public AbstractProjectReport(T project, Integer functionCcnViolationThreshold, Integer functionNcssViolationThreshold) {
        super(project, functionCcnViolationThreshold, functionNcssViolationThreshold);
    }

    public String getIconFileName() {
        for (AbstractBuild build = (AbstractBuild)this.getProject().getLastBuild(); build != null; build = (AbstractBuild)build.getPreviousBuild()) {
            AbstractBuildReport action = (AbstractBuildReport)build.getAction(this.getBuildActionClass());
            if (action == null) continue;
            return PluginImpl.ICON_FILE_NAME;
        }
        return null;
    }

    public String getDisplayName() {
        for (AbstractBuild build = (AbstractBuild)this.getProject().getLastBuild(); build != null; build = (AbstractBuild)build.getPreviousBuild()) {
            AbstractBuildReport action = (AbstractBuildReport)build.getAction(this.getBuildActionClass());
            if (action == null) continue;
            return PluginImpl.DISPLAY_NAME;
        }
        return null;
    }

    @Override
    public String getGraphName() {
        return PluginImpl.GRAPH_NAME;
    }

    public String getUrlName() {
        for (AbstractBuild build = (AbstractBuild)this.getProject().getLastBuild(); build != null; build = (AbstractBuild)build.getPreviousBuild()) {
            AbstractBuildReport action = (AbstractBuildReport)build.getAction(this.getBuildActionClass());
            if (action == null) continue;
            return PluginImpl.URL;
        }
        return null;
    }

    public String getSearchUrl() {
        return PluginImpl.URL;
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (GraphHelper.isGraphUnsupported()) {
            GraphHelper.redirectWhenGraphUnsupported(rsp, req);
            return;
        }
        Calendar t = ((AbstractBuild)this.getProject().getLastBuild()).getTimestamp();
        if (req.checkIfModified(t, rsp)) {
            return;
        }
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)GraphHelper.buildChart((AbstractBuild)this.getProject().getLastBuild(), this.getFunctionCcnViolationThreshold(), this.getFunctionNcssViolationThreshold()), (int)this.getGraphWidth(), (int)this.getGraphHeight());
    }

    @Override
    public boolean isGraphActive() {
        AbstractBuild build = (AbstractBuild)this.getProject().getLastBuild();
        int numPoints = 0;
        while (numPoints < 2) {
            if (build == null) {
                return false;
            }
            if (build.getAction(this.getBuildActionClass()) != null) {
                ++numPoints;
            }
            build = (AbstractBuild)build.getPreviousBuild();
        }
        return true;
    }

    public StatisticsResult getResults() {
        for (AbstractBuild build = (AbstractBuild)this.getProject().getLastBuild(); build != null; build = (AbstractBuild)build.getPreviousBuild()) {
            AbstractBuildReport action = (AbstractBuildReport)build.getAction(this.getBuildActionClass());
            if (action == null) continue;
            return action.getResults();
        }
        return new StatisticsResult();
    }

    public StatisticsTotalResult getTotals() {
        for (AbstractBuild build = (AbstractBuild)this.getProject().getLastBuild(); build != null; build = (AbstractBuild)build.getPreviousBuild()) {
            AbstractBuildReport action = (AbstractBuildReport)build.getAction(this.getBuildActionClass());
            if (action == null) continue;
            return action.getTotals();
        }
        return null;
    }

    protected abstract Class<? extends AbstractBuildReport> getBuildActionClass();

    public int getGraphWidth() {
        return 500;
    }

    public int getGraphHeight() {
        return 200;
    }
}

